/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.FulibTools;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.utils.Association;

public class ClassDiagramConstructor {
    private List<Data> objects;
    private final Map<String, Clazz> clazzMap = new HashMap<String, Clazz>();
    private final List<Association> associations = new ArrayList<Association>();
    private final List<String> reservedStringsForAssoc = new ArrayList<String>();

    public String buildClassDiagram(List<Data> objects) {
        this.objects = objects;
        ClassModelManager mm = new ClassModelManager();
        this.createClazz(mm);
        this.buildAssociations();
        this.createAttributes(mm);
        this.createAssociations(mm);
        return this.generateClassDiagram(mm.getClassModel());
    }

    private void createAssociations(ClassModelManager mm) {
        for (Association assoc : this.associations) {
            if (assoc.srcClazz == null || assoc.tgtClazz == null) continue;
            mm.associate(assoc.srcClazz, assoc.srcName, assoc.srcCardi, assoc.tgtClazz, assoc.tgtName, assoc.tgtCardi);
        }
    }

    private void buildAssociations() {
        for (Data object : this.objects) {
            Association association = new Association();
            String currentClass = object.getName().split(" ")[0].toLowerCase();
            for (Integer integer : object.getData().keySet()) {
                Clazz currentClazz;
                Pair<String, String> pair = object.getData().get(integer);
                if (!((String)pair.a).contains(".")) continue;
                String[] split = ((String)pair.a).split("\\.");
                this.reservedStringsForAssoc.add(split[0]);
                association.srcName = split[0];
                String backName = (String)pair.b;
                if (backName.contains("[")) {
                    backName = this.cleanupString(backName);
                    association.tgtCardi = 42;
                } else {
                    association.tgtCardi = 1;
                }
                association.tgtName = backName;
                association.srcClazz = currentClazz = this.clazzMap.get(currentClass);
                if (association.tgtName.equals(association.srcName)) {
                    association.tgtClazz = currentClazz;
                } else {
                    String objectName = this.getCorrectDataEntry(object, split[0], association);
                    String tgtClassName = this.findClazz(objectName);
                    if (tgtClassName != null) {
                        association.tgtClazz = this.clazzMap.get(tgtClassName.toLowerCase());
                    }
                }
                this.associations.add(association);
                this.reservedStringsForAssoc.add(backName);
            }
        }
    }

    private String getCorrectDataEntry(Data object, String tgtName, Association association) {
        for (Integer integer : object.getData().keySet()) {
            Pair<String, String> pair = object.getData().get(integer);
            String key = (String)pair.a;
            if (!key.equals(tgtName)) continue;
            association.srcCardi = ((String)pair.b).contains("[") ? 42 : 1;
            return (String)pair.b;
        }
        return null;
    }

    private String findClazz(String searchName) {
        for (Data object : this.objects) {
            String objectName = object.getName().split(" ")[1];
            if (!objectName.equals(searchName = this.cleanupString(searchName))) continue;
            return object.getName().split(" ")[0];
        }
        return null;
    }

    private void createAttributes(ClassModelManager mm) {
        for (Data object : this.objects) {
            for (Integer integer : object.getData().keySet()) {
                Pair<String, String> pair = object.getData().get(integer);
                String attributeName = (String)pair.a;
                String className = object.getName().split(" ")[0].toLowerCase();
                Clazz clazz = this.clazzMap.get(className);
                if (this.reservedStringsForAssoc.contains(attributeName) || attributeName.contains(".")) continue;
                String type = this.evaluateAttributeType((String)pair.b);
                mm.haveAttribute(clazz, attributeName, type);
            }
        }
    }

    private void createClazz(ClassModelManager mm) {
        for (Data object : this.objects) {
            String className = object.getName().split(" ")[0];
            this.clazzMap.put(className.toLowerCase(), mm.haveClass(className));
        }
    }

    private String generateClassDiagram(ClassModel classModel) {
        String fileName = "tmp/test/classdiagram";
        String result = "";
        fileName = FulibTools.classDiagrams().dumpSVG(classModel, fileName);
        try {
            result = Files.readString(Path.of(fileName + ".svg", new String[0]));
            Files.deleteIfExists(Path.of(fileName + ".svg", new String[0]));
            Files.deleteIfExists(Path.of("tmp/test/", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String cleanupString(String string) {
        String result = string;
        result = result.replaceAll("\\[", "");
        result = result.replaceAll("]", "");
        result = result.replaceAll(",", "");
        return result;
    }

    private String evaluateAttributeType(String value) {
        Pattern intPattern = Pattern.compile("^\\d+");
        boolean isInt = intPattern.matcher(value).find();
        if (isInt) {
            return "int";
        }
        return "String";
    }
}

