/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.generators.constructors.FxmlConstructor;

public class FxmlGenerator {
    public void buildAndGenerateFxmls(Board board) {
        Map<String, String> generatedFxmls = this.buildFxmls(board);
        for (String key : generatedFxmls.keySet()) {
            this.generateDiagram(generatedFxmls.get(key), key);
        }
    }

    public Map<String, String> buildFxmls(Board board) {
        FxmlConstructor fxmlConstructor = new FxmlConstructor();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ArrayList<String> fxmls = new ArrayList<String>();
        for (Workflow workflow : board.getWorkflows()) {
            for (BaseNote note : workflow.getNotes()) {
                String fxmlString;
                if (!(note instanceof Page) || (fxmlString = fxmlConstructor.buildFxml((Page)note)) == null) continue;
                fxmls.add(fxmlString);
            }
        }
        for (int i = 0; i < fxmls.size(); ++i) {
            String page = (String)fxmls.get(i);
            resultMap.put(i + "_fxml", page);
        }
        return resultMap;
    }

    private void generateDiagram(String fxmlContent, String fileName) {
        try {
            String outputDirectory = "tmp/fxmls/";
            Files.createDirectories(Path.of(outputDirectory, new String[0]), new FileAttribute[0]);
            String outputFxmlFilePath = outputDirectory + fileName + ".fxml";
            if (!Files.exists(Path.of(outputFxmlFilePath, new String[0]), new LinkOption[0])) {
                Files.createFile(Path.of(outputFxmlFilePath, new String[0]), new FileAttribute[0]);
            }
            Files.writeString(Path.of(outputFxmlFilePath, new String[0]), (CharSequence)fxmlContent, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

