/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Command;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.events.Event;
import org.fulib.workflows.events.ExternalSystem;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Policy;
import org.fulib.workflows.events.Problem;
import org.fulib.workflows.events.Service;
import org.fulib.workflows.events.User;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.yaml.FulibWorkflowsBaseListener;
import org.fulib.workflows.yaml.FulibWorkflowsParser;

public class OwnFulibWorkflowsListener
extends FulibWorkflowsBaseListener {
    private Board board;
    private int workflowIndex = 0;
    private Workflow currentWorkflow;
    private final List<Workflow> workflows = new ArrayList<Workflow>();
    private int noteIndex = 0;
    private List<BaseNote> notes = new ArrayList<BaseNote>();
    private int dataIndex = 0;
    private Map<Integer, Pair<String, String>> noteData;

    @Override
    public void enterFile(FulibWorkflowsParser.FileContext ctx) {
        this.board = new Board();
    }

    @Override
    public void exitFile(FulibWorkflowsParser.FileContext ctx) {
        this.board.setWorkflows(this.workflows);
    }

    @Override
    public void enterWorkflow(FulibWorkflowsParser.WorkflowContext ctx) {
        this.currentWorkflow = new Workflow();
    }

    @Override
    public void exitWorkflow(FulibWorkflowsParser.WorkflowContext ctx) {
        this.currentWorkflow.setName(ctx.NAME().getText());
        this.currentWorkflow.setIndex(this.workflowIndex);
        ++this.workflowIndex;
        this.workflows.add(this.currentWorkflow);
        this.resetData();
    }

    @Override
    public void enterEventNote(FulibWorkflowsParser.EventNoteContext ctx) {
        this.dataIndex = 0;
    }

    @Override
    public void exitEventNote(FulibWorkflowsParser.EventNoteContext ctx) {
        this.workflows.get(this.workflowIndex - 1).setNotes(this.notes);
    }

    @Override
    public void exitNormalNote(FulibWorkflowsParser.NormalNoteContext ctx) {
        String noteType;
        BaseNote newNote = new BaseNote();
        switch (noteType = ctx.NORMALNOTEKEY().getText()) {
            case "externalSystem": {
                newNote = new ExternalSystem();
                break;
            }
            case "service": {
                newNote = new Service();
                break;
            }
            case "command": {
                newNote = new Command();
                break;
            }
            case "policy": {
                newNote = new Policy();
                break;
            }
            case "user": {
                newNote = new User();
                break;
            }
            case "problem": {
                newNote = new Problem();
            }
        }
        newNote.setName(ctx.NAME().getText());
        newNote.setIndex(this.noteIndex);
        ++this.noteIndex;
        this.notes.add(newNote);
    }

    @Override
    public void enterExtendedNote(FulibWorkflowsParser.ExtendedNoteContext ctx) {
        this.noteData = new HashMap<Integer, Pair<String, String>>();
    }

    @Override
    public void exitExtendedNote(FulibWorkflowsParser.ExtendedNoteContext ctx) {
        String noteType;
        BaseNote newNote = new BaseNote();
        switch (noteType = ctx.EXTENDEDNOTEKEY().getText()) {
            case "event": {
                newNote = new Event().setData(this.noteData);
                break;
            }
            case "data": {
                newNote = new Data().setData(this.noteData);
            }
        }
        newNote.setName(ctx.NAME().getText());
        newNote.setIndex(this.noteIndex);
        ++this.noteIndex;
        this.notes.add(newNote);
    }

    @Override
    public void exitPage(FulibWorkflowsParser.PageContext ctx) {
        Page newPage = new Page();
        newPage.setContent(this.noteData);
        newPage.setIndex(this.noteIndex);
        ++this.noteIndex;
        this.notes.add(newPage);
    }

    @Override
    public void enterPageList(FulibWorkflowsParser.PageListContext ctx) {
        this.noteData = new HashMap<Integer, Pair<String, String>>();
        this.dataIndex = 0;
    }

    @Override
    public void exitPageName(FulibWorkflowsParser.PageNameContext ctx) {
        this.addNoteDataEntry("name", ctx.NAME().getText());
    }

    @Override
    public void exitElement(FulibWorkflowsParser.ElementContext ctx) {
        this.addNoteDataEntry(ctx.ELEMENTKEY().getText(), ctx.NAME().getText());
    }

    @Override
    public void exitAttribute(FulibWorkflowsParser.AttributeContext ctx) {
        String key = ctx.NAME().getText();
        FulibWorkflowsParser.ValueContext valueContext = ctx.value();
        TerminalNode name = valueContext.NAME();
        TerminalNode number = valueContext.NUMBER();
        TerminalNode list = valueContext.LIST();
        String value = name != null ? name.getText() : (number != null ? number.getText() : (list != null ? list.getText() : "Wrong Value"));
        this.addNoteDataEntry(key, value);
    }

    private void addNoteDataEntry(String key, String value) {
        this.noteData.put(this.dataIndex, (Pair<String, String>)new Pair((Object)key, (Object)value));
        ++this.dataIndex;
    }

    private void resetData() {
        this.currentWorkflow = null;
        this.noteIndex = 0;
        this.notes = new ArrayList<BaseNote>();
        this.dataIndex = 0;
        this.noteData = new HashMap<Integer, Pair<String, String>>();
    }

    public Board getBoard() {
        return this.board;
    }
}

