/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.generators.DiagramGenerator;
import org.fulib.workflows.generators.FxmlGenerator;
import org.fulib.workflows.generators.HtmlGenerator;
import org.fulib.workflows.yaml.FulibWorkflowsLexer;
import org.fulib.workflows.yaml.FulibWorkflowsParser;
import org.fulib.workflows.yaml.OwnFulibWorkflowsListener;

public class BoardGenerator {
    private final HtmlGenerator htmlGenerator = new HtmlGenerator();
    private final DiagramGenerator diagramGenerator = new DiagramGenerator();
    private final FxmlGenerator fxmlGenerator = new FxmlGenerator();

    public void generateBoardFromFile(Path yamlFile) {
        try {
            CharStream inputStream = CharStreams.fromPath((Path)yamlFile);
            Board board = this.generateBoard(inputStream);
            this.htmlGenerator.buildAndGenerateHTML(board);
            this.diagramGenerator.buildAndGenerateDiagram(board);
            this.fxmlGenerator.buildAndGenerateFxmls(board);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateBoardFromString(String yamlContent) {
        CodePointCharStream inputStream = CharStreams.fromString((String)yamlContent);
        Board board = this.generateBoard((CharStream)inputStream);
        this.htmlGenerator.buildAndGenerateHTML(board);
        this.diagramGenerator.buildAndGenerateDiagram(board);
        this.fxmlGenerator.buildAndGenerateFxmls(board);
    }

    public Map<String, String> generateAndReturnHTMLsFromFile(Path yamlFile) {
        try {
            CharStream inputStream = CharStreams.fromPath((Path)yamlFile);
            Board board = this.generateBoard(inputStream);
            return this.buildAndReturnFiles(board);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> generateAndReturnHTMLsFromString(String yamlContent) {
        CodePointCharStream inputStream = CharStreams.fromString((String)yamlContent);
        Board board = this.generateBoard((CharStream)inputStream);
        return this.buildAndReturnFiles(board);
    }

    private Map<String, String> buildAndReturnFiles(Board board) {
        Map<String, String> result = new HashMap<String, String>();
        Map<String, String> boardAndPages = this.htmlGenerator.buildHTMLs(board);
        result = this.mergeMaps(result, boardAndPages);
        Map<String, String> diagrams = this.diagramGenerator.buildDiagrams(board);
        result = this.mergeMaps(result, diagrams);
        Map<String, String> fxmls = this.fxmlGenerator.buildFxmls(board);
        result = this.mergeMaps(result, fxmls);
        return result;
    }

    private Map<String, String> mergeMaps(Map<String, String> mainMap, Map<String, String> toBeMerged) {
        HashMap<String, String> result = new HashMap<String, String>(mainMap);
        toBeMerged.forEach((key, value) -> result.merge((String)key, (String)value, (v1, v2) -> ""));
        return result;
    }

    private Board generateBoard(CharStream inputStream) {
        FulibWorkflowsLexer fulibWorkflowsLexer = new FulibWorkflowsLexer(inputStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)fulibWorkflowsLexer);
        FulibWorkflowsParser fulibWorkflowsParser = new FulibWorkflowsParser((TokenStream)commonTokenStream);
        FulibWorkflowsParser.FileContext fileContext = fulibWorkflowsParser.file();
        OwnFulibWorkflowsListener ownFulibWorkflowsListener = new OwnFulibWorkflowsListener();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)ownFulibWorkflowsListener, (ParseTree)fileContext);
        return ownFulibWorkflowsListener.getBoard();
    }
}

