/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.generators.constructors.BoardConstructor;
import org.fulib.workflows.generators.constructors.PageConstructor;

public class HtmlGenerator {
    public void buildAndGenerateHTML(Board board) {
        Map<String, String> generatedHTMLs = this.buildHTMLs(board);
        for (String key : generatedHTMLs.keySet()) {
            if (key.equals("Board")) {
                this.generateHTML(generatedHTMLs.get(key), key, "");
                continue;
            }
            this.generateHTML(generatedHTMLs.get(key), key, "pages/");
        }
    }

    public Map<String, String> buildHTMLs(Board board) {
        BoardConstructor boardConstructor = new BoardConstructor();
        PageConstructor pageConstructor = new PageConstructor();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("Board", boardConstructor.buildBoard(board));
        ArrayList<String> pagesHTML = new ArrayList<String>();
        for (Workflow workflow : board.getWorkflows()) {
            for (BaseNote note : workflow.getNotes()) {
                if (!(note instanceof Page)) continue;
                pagesHTML.add(pageConstructor.buildPage((Page)note));
            }
        }
        for (int i = 0; i < pagesHTML.size(); ++i) {
            String page = (String)pagesHTML.get(i);
            resultMap.put(i + "_page", page);
        }
        return resultMap;
    }

    private void generateHTML(String htmlContent, String fileName, String subFolder) {
        try {
            String outputDirectory = "tmp/" + subFolder;
            Files.createDirectories(Path.of(outputDirectory, new String[0]), new FileAttribute[0]);
            String outputBoardFilePath = outputDirectory + fileName + ".html";
            if (!Files.exists(Path.of(outputBoardFilePath, new String[0]), new LinkOption[0])) {
                Files.createFile(Path.of(outputBoardFilePath, new String[0]), new FileAttribute[0]);
            }
            Files.writeString(Path.of(outputBoardFilePath, new String[0]), (CharSequence)htmlContent, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

