/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.generators.DiagramGenerator;
import org.fulib.workflows.generators.FxmlGenerator;
import org.fulib.workflows.generators.HtmlGenerator;
import org.fulib.workflows.yaml.OwnYamlParser;

public class BoardGenerator {
    private final DiagramGenerator diagramGenerator = new DiagramGenerator();
    private final FxmlGenerator fxmlGenerator = new FxmlGenerator();
    private HtmlGenerator htmlGenerator;
    private boolean webGeneration = false;

    public void generateBoardFromFile(Path yamlFile) {
        try {
            String inputStream = Files.readString(yamlFile);
            Board board = this.generateBoard(inputStream);
            this.htmlGenerator = new HtmlGenerator(board, this);
            this.htmlGenerator.buildAndGenerateHTML(board);
            this.diagramGenerator.buildAndGenerateDiagram(board);
            this.fxmlGenerator.buildAndGenerateFxmls(board);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateBoardFromString(String yamlContent) {
        Board board = this.generateBoard(yamlContent);
        this.htmlGenerator = new HtmlGenerator(board, this);
        this.htmlGenerator.buildAndGenerateHTML(board);
        this.diagramGenerator.buildAndGenerateDiagram(board);
        this.fxmlGenerator.buildAndGenerateFxmls(board);
    }

    public Map<String, String> generateAndReturnHTMLsFromFile(Path yamlFile) {
        try {
            String inputStream = Files.readString(yamlFile);
            Board board = this.generateBoard(inputStream);
            this.htmlGenerator = new HtmlGenerator(board, this);
            return this.buildAndReturnFiles(board);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> generateAndReturnHTMLsFromString(String yamlContent) {
        Board board = this.generateBoard(yamlContent);
        this.htmlGenerator = new HtmlGenerator(board, this);
        return this.buildAndReturnFiles(board);
    }

    private Map<String, String> buildAndReturnFiles(Board board) {
        Map<String, String> result = new HashMap<String, String>();
        Map<String, String> boardAndPages = this.htmlGenerator.buildHTMLs(board);
        result = this.mergeMaps(result, boardAndPages);
        Map<String, String> diagrams = this.diagramGenerator.buildDiagrams(board);
        result = this.mergeMaps(result, diagrams);
        Map<String, String> fxmls = this.fxmlGenerator.buildFxmls(board);
        result = this.mergeMaps(result, fxmls);
        return result;
    }

    private Map<String, String> mergeMaps(Map<String, String> mainMap, Map<String, String> toBeMerged) {
        HashMap<String, String> result = new HashMap<String, String>(mainMap);
        toBeMerged.forEach((key, value) -> result.merge((String)key, (String)value, (v1, v2) -> ""));
        return result;
    }

    private Board generateBoard(String yamlContent) {
        OwnYamlParser ownYamlParser = new OwnYamlParser();
        ownYamlParser.parseYAML(yamlContent);
        return ownYamlParser.getBoard();
    }

    public boolean isWebGeneration() {
        return this.webGeneration;
    }

    public void setWebGeneration(boolean webGeneration) {
        this.webGeneration = webGeneration;
    }
}

