/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.FulibTools;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.generators.constructors.PageConstructor;
import org.fulib.workflows.utils.IncorrectDataValueException;
import org.fulib.yaml.YamlIdMap;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class ObjectDiagramConstructor {
    private STGroupFile fulibYamlGroup;
    private String currentNoteName;

    public String buildObjectDiagram(List<Data> notes, int index) {
        String objectYaml = this.buildFulibYamlNotation(notes);
        return this.generateObjectDiagram(objectYaml, index);
    }

    private String buildFulibYamlNotation(List<Data> notes) {
        URL resource = PageConstructor.class.getResource("FulibYaml.stg");
        this.fulibYamlGroup = new STGroupFile(Objects.requireNonNull(resource));
        StringBuilder yamlBody = new StringBuilder();
        Data currentNote = notes.get(notes.size() - 1);
        this.buildFulibYamlObject(currentNote, yamlBody);
        for (int i = 0; i < notes.size() - 1; ++i) {
            Data note = notes.get(i);
            this.buildFulibYamlObject(note, yamlBody);
        }
        return yamlBody.toString();
    }

    private void buildFulibYamlObject(Data note, StringBuilder yamlBody) {
        ST st = this.fulibYamlGroup.getInstanceOf("object");
        String[] s = note.getName().split(" ");
        try {
            st.add("name", (Object)s[1]);
            this.currentNoteName = s[1];
        }
        catch (Exception e) {
            try {
                throw new IncorrectDataValueException("Invalid value. Needs to be '- data: <ClassName> <objectName>'");
            }
            catch (IncorrectDataValueException ex) {
                ex.printStackTrace();
            }
        }
        st.add("type", (Object)s[0]);
        st.add("attributes", (Object)this.buildAttributes(note));
        yamlBody.append(st.render());
    }

    private String buildAttributes(Data note) {
        StringBuilder attributesBody = new StringBuilder();
        for (int i = 0; i < note.getData().size(); ++i) {
            Pair<String, String> pair = note.getData().get(i);
            ST st = this.fulibYamlGroup.getInstanceOf("attribute");
            String type = (String)pair.a;
            Object value = (String)pair.b;
            if (type.contains(".")) continue;
            if (((String)value).contains("[") || ((String)value).contains(">")) {
                value = ((String)value).replaceAll("\\[", "");
                value = ((String)value).replaceAll("]", "");
                value = ((String)value).replaceAll(",", "");
            } else {
                value = "\"" + (String)value + "\"";
            }
            st.add("type", (Object)type);
            st.add("value", value);
            attributesBody.append(st.render());
        }
        return attributesBody.toString();
    }

    private String generateObjectDiagram(String objectYaml, int index) {
        Object fileName = "genTmp/diagrams/diagram_" + index;
        String result = "";
        YamlIdMap idMap = new YamlIdMap(new String[0]);
        Object root = idMap.decode(objectYaml);
        fileName = FulibTools.objectDiagrams().dumpSVG((String)fileName, new Object[]{root});
        try {
            result = Files.readString(Path.of((String)fileName + ".svg", new String[0]));
            Files.deleteIfExists(Path.of((String)fileName + ".svg", new String[0]));
            Files.deleteIfExists(Path.of("genTmp/diagrams/", new String[0]));
            Files.deleteIfExists(Path.of("genTmp/", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

