/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.FulibTools;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.utils.Association;
import org.fulib.yaml.YamlObject;

public class ClassDiagramConstructor {
    private List<Data> objects;
    private final Map<String, Clazz> clazzMap = new HashMap<String, Clazz>();
    private final List<Association> associations = new ArrayList<Association>();
    private final List<String> reservedStringsForAssoc = new ArrayList<String>();
    private Map<String, YamlObject> yamlGraph;

    public String buildClassDiagram(List<Data> objects, Map<String, YamlObject> yamlGraph) {
        this.objects = objects;
        this.yamlGraph = yamlGraph;
        ClassModelManager mm = new ClassModelManager();
        this.createClazz(mm);
        for (YamlObject yamlObject : yamlGraph.values()) {
            if (yamlObject.getType() == null) continue;
            Clazz myClass = mm.haveClass(yamlObject.getType());
            mm.haveAttribute(myClass, "name", "String");
            for (Map.Entry entry : yamlObject.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key.contains(".")) continue;
                YamlObject yamlValue = this.getOneYamlValue(value);
                if (yamlValue != null && yamlValue.getType() != null) {
                    Clazz valueClass = mm.haveClass(yamlValue.getType());
                    int valueSize = this.getSize(value);
                    Map.Entry<String, Object> revEntry = this.findReverseReference(yamlValue, yamlObject);
                    if (revEntry == null) continue;
                    String revKey = revEntry.getKey();
                    Object revValue = revEntry.getValue();
                    YamlObject revYamlObject = this.getOneYamlValue(revValue);
                    int revSize = this.getSize(revValue);
                    try {
                        mm.haveRole(myClass, key, valueSize, valueClass, revKey, revSize);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (key.startsWith(".") || key.equals("type")) continue;
                String type = this.learnTypeFromValue(value);
                mm.haveAttribute(myClass, key, type);
            }
        }
        String classDiagramString = this.generateClassDiagram(mm.getClassModel());
        if (mm.getClassModel().getClasses().size() > 0) {
            return classDiagramString;
        }
        return null;
    }

    private String learnTypeFromValue(Object value) {
        try {
            int parseInt = Integer.parseInt(value.toString());
            return "int";
        }
        catch (Exception parseInt) {
            try {
                double parse = Double.parseDouble(value.toString().replace(',', '.'));
                return "double";
            }
            catch (Exception exception) {
                return "String";
            }
        }
    }

    private YamlObject getOneYamlValue(Object value) {
        if (value instanceof Collection) {
            Collection set = (Collection)value;
            return (YamlObject)set.toArray()[0];
        }
        if (value instanceof YamlObject) {
            YamlObject yamlValue = (YamlObject)value;
            return yamlValue;
        }
        return null;
    }

    private int getSize(Object value) {
        if (value instanceof Collection) {
            return 42;
        }
        if (value instanceof YamlObject) {
            return 1;
        }
        return 0;
    }

    private Clazz getTargetClass(ClassModelManager mm, Object value) {
        if (value instanceof Collection) {
            Collection set = (Collection)value;
            value = set.toArray()[0];
        }
        if (value instanceof YamlObject) {
            YamlObject yamlObject = (YamlObject)value;
            return mm.haveClass(yamlObject.getType());
        }
        return null;
    }

    private Map.Entry<String, Object> findReverseReference(YamlObject yamlTgt, YamlObject yamlObject) {
        for (Map.Entry<String, Object> entry : yamlTgt.getProperties().entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof Collection)) continue;
            Collection revCollection = (Collection)v;
            if (revCollection.contains(yamlObject)) {
                return entry;
            }
            if (entry.getValue() != yamlObject) continue;
            return entry;
        }
        return null;
    }

    private void createAssociations(ClassModelManager mm) {
        for (Association assoc : this.associations) {
            if (assoc.srcClazz == null || assoc.tgtClazz == null) continue;
            mm.associate(assoc.srcClazz, assoc.srcName, assoc.srcCardi, assoc.tgtClazz, assoc.tgtName, assoc.tgtCardi);
        }
    }

    private void buildAssociations() {
        for (Data object : this.objects) {
            Association association = new Association();
            String currentClass = object.getName().split(" ")[0].toLowerCase();
            for (Integer integer : object.getData().keySet()) {
                Clazz currentClazz;
                Pair<String, String> pair = object.getData().get(integer);
                if (!((String)pair.a).contains(".")) continue;
                String[] split = ((String)pair.a).split("\\.");
                this.reservedStringsForAssoc.add(split[0]);
                association.srcName = split[0];
                String backName = (String)pair.b;
                if (backName.startsWith("[")) {
                    backName = this.cleanupString(backName);
                    association.tgtCardi = 42;
                } else {
                    association.tgtCardi = 1;
                }
                association.tgtName = backName;
                association.srcClazz = currentClazz = this.clazzMap.get(currentClass);
                if (association.tgtName.equals(association.srcName)) {
                    association.tgtClazz = currentClazz;
                } else {
                    String objectName = this.getCorrectDataEntry(object, split[0], association);
                    String tgtClassName = this.findClazz(objectName);
                    if (tgtClassName != null) {
                        association.tgtClazz = this.clazzMap.get(tgtClassName.toLowerCase());
                    }
                }
                this.associations.add(association);
                this.reservedStringsForAssoc.add(backName);
            }
        }
    }

    private String getCorrectDataEntry(Data object, String tgtName, Association association) {
        for (Integer integer : object.getData().keySet()) {
            Pair<String, String> pair = object.getData().get(integer);
            String key = (String)pair.a;
            if (!key.equals(tgtName)) continue;
            association.srcCardi = ((String)pair.b).startsWith("[") ? 42 : 1;
            return (String)pair.b;
        }
        return null;
    }

    private String findClazz(String searchName) {
        for (Data object : this.objects) {
            String objectName = object.getName().split(" ")[1];
            if (!objectName.equals(searchName = this.cleanupString(searchName))) continue;
            return object.getName().split(" ")[0];
        }
        return null;
    }

    private void createAttributes(ClassModelManager mm) {
        for (Data object : this.objects) {
            for (Integer integer : object.getData().keySet()) {
                Pair<String, String> pair = object.getData().get(integer);
                String attributeName = (String)pair.a;
                String className = object.getName().split(" ")[0].toLowerCase();
                Clazz clazz = this.clazzMap.get(className);
                if (this.reservedStringsForAssoc.contains(attributeName) || attributeName.contains(".")) continue;
                String type = this.evaluateAttributeType((String)pair.b);
                mm.haveAttribute(clazz, attributeName, type);
            }
        }
    }

    private void createClazz(ClassModelManager mm) {
        for (YamlObject object : this.yamlGraph.values()) {
            if (object.getType() == null) continue;
            String className = object.getType();
            this.clazzMap.put(className.toLowerCase(), mm.haveClass(className));
        }
    }

    private String generateClassDiagram(ClassModel classModel) {
        String fileName = "genTmp/diagrams/classdiagram";
        String result = "";
        fileName = FulibTools.classDiagrams().dumpSVG(classModel, fileName);
        try {
            result = Files.readString(Path.of(fileName + ".svg", new String[0]));
            Files.deleteIfExists(Path.of(fileName + ".svg", new String[0]));
            Files.deleteIfExists(Path.of("genTmp/diagrams/", new String[0]));
            Files.deleteIfExists(Path.of("genTmp/", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String cleanupString(String string) {
        String result = string;
        result = result.replaceAll("\\[", "");
        result = result.replaceAll("]", "");
        result = result.replaceAll(",", "");
        return result;
    }

    private String evaluateAttributeType(String value) {
        Pattern intPattern = Pattern.compile("^\\d+");
        boolean isInt = intPattern.matcher(value).find();
        if (isInt) {
            return "int";
        }
        return "String";
    }
}

