/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.events.Service;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.generators.BoardGenerator;
import org.fulib.workflows.generators.constructors.ClassDiagramConstructor;
import org.fulib.workflows.generators.constructors.ObjectDiagramConstructor;
import org.fulib.yaml.YamlObject;

public class DiagramGenerator {
    private BoardGenerator boardGenerator;

    DiagramGenerator(BoardGenerator boardGenerator) {
        this.boardGenerator = boardGenerator;
    }

    public void buildAndGenerateDiagram(Board board) {
        Map<String, String> generatedDiagrams = this.buildDiagrams(board);
        for (String key : generatedDiagrams.keySet()) {
            this.generateDiagram(generatedDiagrams.get(key), key, key.startsWith("classDiagram"));
        }
    }

    public Map<String, String> buildDiagrams(Board board) {
        ObjectDiagramConstructor diagramConstructor = new ObjectDiagramConstructor();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ArrayList<String> diagrams = new ArrayList<String>();
        HashMap<String, List> previousServiceData = new HashMap<String, List>();
        String currentService = "default";
        List previousData = new ArrayList();
        for (Workflow workflow : board.getWorkflows()) {
            for (BaseNote note : workflow.getNotes()) {
                if (note instanceof Service) {
                    Service service = (Service)note;
                    currentService = service.getName();
                    continue;
                }
                if (!(note instanceof Data)) continue;
                previousData = previousServiceData.computeIfAbsent(currentService, k -> new ArrayList());
                previousData.add((Data)note);
                String diagramString = diagramConstructor.buildObjectDiagram(previousData, note.getIndex());
                if (diagramString == null) continue;
                diagrams.add(diagramString);
            }
        }
        for (int i = 0; i < diagrams.size(); ++i) {
            String diagram = (String)diagrams.get(i);
            resultMap.put(i + "_diagram", diagram);
        }
        ClassDiagramConstructor classDiagramConstructor = new ClassDiagramConstructor();
        for (Map.Entry entry : previousServiceData.entrySet()) {
            Map<String, YamlObject> yamlGraph;
            String key = (String)entry.getKey();
            previousData = (List)entry.getValue();
            String classdiagramString = classDiagramConstructor.buildClassDiagram(previousData, yamlGraph = diagramConstructor.buildFulibGraphDiagram(previousData));
            if (classdiagramString == null) continue;
            resultMap.put("classDiagram_" + key, classdiagramString);
        }
        return resultMap;
    }

    private void generateDiagram(String diagramContent, String fileName, boolean isClass) {
        try {
            Object outputDirectory = this.boardGenerator.getGenDir();
            outputDirectory = (String)outputDirectory + (isClass ? "/class/" : "/diagrams/");
            Files.createDirectories(Path.of((String)outputDirectory, new String[0]), new FileAttribute[0]);
            String outputDiagramFilePath = (String)outputDirectory + fileName + ".svg";
            if (!Files.exists(Path.of(outputDiagramFilePath, new String[0]), new LinkOption[0])) {
                Files.createFile(Path.of(outputDiagramFilePath, new String[0]), new FileAttribute[0]);
            }
            Files.writeString(Path.of(outputDiagramFilePath, new String[0]), (CharSequence)diagramContent, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

