/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Command;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.events.Event;
import org.fulib.workflows.events.ExternalSystem;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Policy;
import org.fulib.workflows.events.Problem;
import org.fulib.workflows.events.Service;
import org.fulib.workflows.events.User;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.generators.constructors.PageConstructor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class BoardConstructor {
    private Board currentBoard;
    private STGroupFile boardGroup;
    private boolean webGeneration;
    private boolean standAlone;

    public String buildBoard(Board board, boolean webGeneration) {
        this.webGeneration = webGeneration;
        this.currentBoard = board;
        URL resource = PageConstructor.class.getResource("Board.stg");
        this.boardGroup = new STGroupFile(Objects.requireNonNull(resource));
        StringBuilder boardBody = new StringBuilder();
        ST st = this.boardGroup.getInstanceOf("board");
        st.add("content", (Object)this.buildBoardContent());
        boardBody.append(st.render());
        return boardBody.toString();
    }

    private String buildBoardContent() {
        StringBuilder boardContent = new StringBuilder();
        for (Workflow workflow : this.currentBoard.getWorkflows()) {
            ST st = this.boardGroup.getInstanceOf("workflow");
            st.add("name", (Object)workflow.getName());
            st.add("content", (Object)this.buildWorkflow(workflow));
            boardContent.append(st.render());
        }
        return boardContent.toString();
    }

    private String buildWorkflow(Workflow workflow) {
        StringBuilder workflowContent = new StringBuilder();
        int pageIndex = 0;
        int dataIndex = 0;
        for (BaseNote note : workflow.getNotes()) {
            ST noteST = this.boardGroup.getInstanceOf("note");
            ST actorST = this.boardGroup.getInstanceOf("actor");
            ST objectNoteST = this.boardGroup.getInstanceOf("objectNote");
            if (this.standAlone) {
                objectNoteST = this.boardGroup.getInstanceOf("objectNoteAlone");
            }
            if (note instanceof Event) {
                Event event = (Event)note;
                noteST.add("name", (Object)"Event");
                noteST.add("content", (Object)this.buildNoteContentFromNote(event, "Event"));
                noteST.add("color", (Object)"orange");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof Command) {
                noteST.add("name", (Object)"Command");
                noteST.add("content", (Object)this.buildNoteContent(note.getName()));
                noteST.add("color", (Object)"lightskyblue");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof Policy) {
                noteST.add("name", (Object)"Policy");
                noteST.add("content", (Object)this.buildNoteContent(note.getName()));
                noteST.add("color", (Object)"#C8A2C8");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof Problem) {
                noteST.add("name", (Object)"Problem");
                noteST.add("content", (Object)this.buildNoteContent(note.getName()));
                noteST.add("color", (Object)"indianred");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof User) {
                actorST.add("color", (Object)"gold");
                actorST.add("icon", (Object)"person-fill");
                actorST.add("name", (Object)note.getName());
                workflowContent.append(actorST.render());
                continue;
            }
            if (note instanceof ExternalSystem) {
                actorST.add("color", (Object)"pink");
                actorST.add("icon", (Object)"hdd-network");
                actorST.add("name", (Object)note.getName());
                workflowContent.append(actorST.render());
                continue;
            }
            if (note instanceof Service) {
                actorST.add("color", (Object)"palevioletred");
                actorST.add("icon", (Object)"pc-horizontal");
                actorST.add("name", (Object)note.getName());
                workflowContent.append(actorST.render());
                continue;
            }
            if (note instanceof Data) {
                Data data = (Data)note;
                objectNoteST.add("content", (Object)this.buildNoteContentFromNote(data, "Data"));
                workflowContent.append(objectNoteST.render());
                this.closeDataOrPageNote(workflowContent, dataIndex, false);
                ++dataIndex;
                continue;
            }
            if (!(note instanceof Page)) continue;
            Page page = (Page)note;
            String pageNote = this.buildPageNote(page);
            workflowContent.append(pageNote);
            this.closeDataOrPageNote(workflowContent, pageIndex, true);
            ++pageIndex;
        }
        return workflowContent.toString();
    }

    private void closeDataOrPageNote(StringBuilder workflowContent, int index, boolean isPage) {
        ST st;
        StringBuilder closeContent = new StringBuilder();
        if (this.webGeneration) {
            st = this.boardGroup.getInstanceOf("linkedNoteLink");
            st.add("index", (Object)index);
            if (isPage) {
                st.add("type", (Object)"pages");
                st.add("description", (Object)"page");
            } else {
                st.add("type", (Object)"objects");
                st.add("description", (Object)"objectdiagram");
            }
            closeContent.append(st.render());
        }
        st = this.boardGroup.getInstanceOf("dataANDPageClose");
        closeContent.append(st.render());
        workflowContent.append((CharSequence)closeContent);
    }

    private String buildNoteContent(String content) {
        StringBuilder textContent = new StringBuilder();
        ST st = this.boardGroup.getInstanceOf("cardText");
        st.add("text", (Object)content);
        textContent.append(st.render());
        return textContent.toString();
    }

    private String buildNoteContentFromNote(BaseNote note, String noteType) {
        ST st;
        Map<Object, Object> contents = new HashMap();
        StringBuilder textContent = new StringBuilder();
        switch (noteType) {
            case "Event": {
                contents = ((Event)note).getData();
                st = this.boardGroup.getInstanceOf("cardText");
                st.add("text", (Object)("name: " + note.getName()));
                textContent.append(st.render());
                break;
            }
            case "Data": {
                contents = ((Data)note).getData();
                st = this.boardGroup.getInstanceOf("cardText");
                st.add("text", (Object)("name: " + note.getName()));
                textContent.append(st.render());
                break;
            }
            default: {
                System.out.println("Unknown Type");
            }
        }
        for (int i = 0; i <= contents.size(); ++i) {
            Pair pair = (Pair)contents.get(i);
            if (pair == null) continue;
            String text = (String)pair.a + ": ";
            text = text + (String)pair.b;
            st = this.boardGroup.getInstanceOf("cardText");
            st.add("text", (Object)text);
            textContent.append(st.render());
        }
        return textContent.toString();
    }

    private String buildPageNote(Page page) {
        ST pageNoteST = this.boardGroup.getInstanceOf("pageNote");
        if (this.standAlone) {
            pageNoteST = this.boardGroup.getInstanceOf("pageNoteAlone");
        }
        pageNoteST.add("name", (Object)page.getName());
        pageNoteST.add("content", (Object)this.buildPageContent(page));
        return pageNoteST.render();
    }

    private String buildPageContent(Page page) {
        StringBuilder pageContent = new StringBuilder();
        Map<Integer, Pair<String, String>> contents = page.getContent();
        block13: for (int i = 0; i < contents.size(); ++i) {
            Pair<String, String> pair = contents.get(i);
            String desc = (String)pair.a;
            String value = (String)pair.b;
            switch (desc) {
                case "text": {
                    ST st = this.boardGroup.getInstanceOf("pageText");
                    st.add("text", (Object)value);
                    pageContent.append(st.render());
                    continue block13;
                }
                case "input": 
                case "password": {
                    ST st = this.boardGroup.getInstanceOf("pageInput");
                    st.add("desc", (Object)value);
                    pageContent.append(st.render());
                    continue block13;
                }
                case "value": {
                    ST st = this.boardGroup.getInstanceOf("pageValue");
                    st.add("value", (Object)value);
                    pageContent.append(st.render());
                    continue block13;
                }
                case "button": {
                    ST st = this.boardGroup.getInstanceOf("pageButton");
                    st.add("desc", (Object)value);
                    pageContent.append(st.render());
                    continue block13;
                }
            }
        }
        return pageContent.toString();
    }

    public BoardConstructor setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
        return this;
    }
}

