/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.generators.DiagramGenerator;
import org.fulib.workflows.generators.FxmlGenerator;
import org.fulib.workflows.generators.HtmlGenerator;
import org.fulib.workflows.yaml.OwnYamlParser;

public class BoardGenerator {
    private DiagramGenerator diagramGenerator;
    private FxmlGenerator fxmlGenerator;
    private HtmlGenerator htmlGenerator;
    private boolean standAlone;
    private boolean webGeneration = false;
    private String genDir = "tmp";

    public void generateBoardFromFile(Path yamlFile) {
        try {
            String yamlContent = Files.readString(yamlFile);
            this.generateBoardFromString(yamlContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateBoardFromString(String yamlContent) {
        Board board = this.generateBoard(yamlContent);
        this.diagramGenerator = new DiagramGenerator(this);
        this.fxmlGenerator = new FxmlGenerator(this);
        this.htmlGenerator = new HtmlGenerator(board, this);
        this.htmlGenerator.buildAndGenerateHTML(board);
        this.diagramGenerator.buildAndGenerateDiagram(board);
        this.fxmlGenerator.buildAndGenerateFxmls(board);
    }

    public Map<String, String> generateAndReturnHTMLsFromFile(Path yamlFile) {
        try {
            String inputStream = Files.readString(yamlFile);
            Board board = this.generateBoard(inputStream);
            this.diagramGenerator = new DiagramGenerator(this);
            this.fxmlGenerator = new FxmlGenerator(this);
            this.htmlGenerator = new HtmlGenerator(board, this);
            return this.buildAndReturnFiles(board);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> generateAndReturnHTMLsFromString(String yamlContent) {
        Board board = this.generateBoard(yamlContent);
        this.diagramGenerator = new DiagramGenerator(this);
        this.fxmlGenerator = new FxmlGenerator(this);
        this.htmlGenerator = new HtmlGenerator(board, this);
        return this.buildAndReturnFiles(board);
    }

    private Map<String, String> buildAndReturnFiles(Board board) {
        Map<String, String> result = new HashMap<String, String>();
        Map<String, String> boardAndPages = this.htmlGenerator.buildHTMLs(board);
        result = this.mergeMaps(result, boardAndPages);
        Map<String, String> diagrams = this.diagramGenerator.buildDiagrams(board);
        result = this.mergeMaps(result, diagrams);
        Map<String, String> fxmls = this.fxmlGenerator.buildFxmls(board);
        result = this.mergeMaps(result, fxmls);
        return result;
    }

    private Map<String, String> mergeMaps(Map<String, String> mainMap, Map<String, String> toBeMerged) {
        HashMap<String, String> result = new HashMap<String, String>(mainMap);
        toBeMerged.forEach((key, value) -> result.merge((String)key, (String)value, (v1, v2) -> ""));
        return result;
    }

    private Board generateBoard(String yamlContent) {
        OwnYamlParser ownYamlParser = new OwnYamlParser();
        ownYamlParser.parseYAML(yamlContent);
        return ownYamlParser.getBoard();
    }

    public boolean isWebGeneration() {
        return this.webGeneration;
    }

    public BoardGenerator setWebGeneration(boolean webGeneration) {
        this.webGeneration = webGeneration;
        return this;
    }

    public String getGenDir() {
        return this.genDir;
    }

    public BoardGenerator setGenDir(String genDir) {
        this.genDir = genDir;
        return this;
    }

    public BoardGenerator setStandAlone() {
        this.standAlone = true;
        return this;
    }
}

