/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.workflows.events.Page;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class PageConstructor {
    private Page currentPage;
    private STGroupFile pageGroup;
    private boolean standAlone;

    public String buildPage(Page page, List<Integer> targetPageIndexList) {
        this.currentPage = page;
        URL resource = PageConstructor.class.getResource("Page.stg");
        this.pageGroup = new STGroupFile(Objects.requireNonNull(resource));
        StringBuilder pageBody = new StringBuilder();
        ST st = this.pageGroup.getInstanceOf("page");
        st.add("content", (Object)this.buildPageContent(targetPageIndexList));
        st.add("pageName", (Object)this.currentPage.getName());
        pageBody.append(st.render());
        return pageBody.toString();
    }

    private String buildPageContent(List<Integer> targetPageIndexList) {
        StringBuilder contentBody = new StringBuilder();
        int targetIndex = 0;
        for (int i = 0; i <= this.currentPage.getContent().size(); ++i) {
            ST st;
            String key;
            if (this.currentPage.getContent().get(i) == null || (key = (String)this.currentPage.getContent().get((Object)Integer.valueOf((int)i)).a).equals("value") || key.equals("targetPage")) continue;
            String value = (String)this.currentPage.getContent().get((Object)Integer.valueOf((int)i)).b;
            Pair<String, String> nextElement = new Pair<String, String>((Object)"", (Object)"");
            if (i + 1 < this.currentPage.getContent().size()) {
                nextElement = this.currentPage.getContent().get(i + 1);
            }
            if (key.contains("text")) {
                st = this.pageGroup.getInstanceOf("text");
                if (value != null && value.startsWith("<pre>")) {
                    st = this.pageGroup.getInstanceOf("pre");
                }
                st.add("text", (Object)value);
                contentBody.append(st.render());
                continue;
            }
            if (key.contains("input")) {
                st = this.pageGroup.getInstanceOf("input");
                st.add("id", (Object)(i + "input"));
                st.add("label", (Object)value);
                st.add("value", (Object)this.getValue(nextElement));
                contentBody.append(st.render());
                continue;
            }
            if (key.contains("password")) {
                st = this.pageGroup.getInstanceOf("password");
                st.add("id", (Object)(i + "password"));
                st.add("label", (Object)value);
                st.add("value", (Object)this.getValue(nextElement));
                contentBody.append(st.render());
                continue;
            }
            if (!key.contains("button")) continue;
            st = this.standAlone ? this.pageGroup.getInstanceOf("buttonAlone") : this.pageGroup.getInstanceOf("button");
            st.add("description", (Object)value);
            int foundTargetIndex = targetIndex < targetPageIndexList.size() ? targetPageIndexList.get(targetIndex).intValue() : this.currentPage.getIndex();
            st.add("targetIndex", (Object)foundTargetIndex);
            ++targetIndex;
            contentBody.append(st.render());
        }
        return contentBody.toString();
    }

    private String getValue(Pair<String, String> nextElement) {
        String result = "";
        if (((String)nextElement.a).equals("value")) {
            result = (String)nextElement.b;
        }
        return result;
    }

    public PageConstructor setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
        return this;
    }
}

