/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.fulib.tools.DGraph;
import org.fulib.tools.Edge;
import org.fulib.tools.Node;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class GraphDiagram {
    private DGraph root = new DGraph().setId("root").toGraph();
    private List<Edge> edges = new ArrayList<Edge>();
    private DGraph currentGraph = this.root;
    private String edgesText;

    public String toSVG() {
        STGroupFile stGroup = null;
        URL resource = GraphDiagram.class.getResource("graph.stg");
        stGroup = resource != null ? new STGroupFile(resource) : new STGroupFile("src/main/resources/uks/gmde2122/graph.stg");
        String modelsText = "";
        this.edgesText = "";
        modelsText = this.nodesOfGraphText(this.root, (STGroup)stGroup);
        for (Edge edge : this.edges) {
            ST est = stGroup.getInstanceOf("edge");
            est.add("src", (Object)edge.getSrcId());
            est.add("srclabel", (Object)edge.getSrcLabel());
            est.add("tgtlabel", (Object)edge.getTgtLabel());
            est.add("tgt", (Object)edge.getTgtId());
            est.add("color", (Object)"black");
            String oneEdge = est.render();
            this.edgesText = this.edgesText + oneEdge;
        }
        ST st = stGroup.getInstanceOf("graph");
        st.add("title", (Object)this.root.getId());
        st.add("objects", (Object)modelsText);
        st.add("edges", (Object)this.edgesText);
        String dotString = st.render();
        String svgString = Graphviz.fromString((String)dotString).render(Format.SVG).toString();
        return svgString;
    }

    private String nodesOfGraphText(DGraph graph, STGroup stGroup) {
        Object modelsText = "";
        for (Node node : graph.getNodes().values()) {
            if (node instanceof DGraph) {
                String subText = this.nodesOfGraphText(node.toGraph(), stGroup);
                ST subGraph = stGroup.getInstanceOf("subgraph");
                subGraph.add("graphId", (Object)node.getId());
                subGraph.add("label", (Object)node.getLabel());
                subGraph.add("objects", (Object)subText);
                String oneSubgraph = subGraph.render();
                modelsText = (String)modelsText + oneSubgraph;
                continue;
            }
            String attrText = node.getAttrText() != null ? node.getAttrText() : "";
            attrText = attrText.replaceAll("\n", "<br align='left'/>");
            ST ost = stGroup.getInstanceOf("simpleObject");
            ost.add("objectId", (Object)node.getId());
            ost.add("label", (Object)node.getLabel());
            ost.add("attrList", (Object)attrText);
            if (node.getHref() != null) {
                ost.add("href", (Object)node.getHref());
            }
            String oneObject = ost.render();
            modelsText = (String)modelsText + oneObject + "\n";
        }
        return modelsText;
    }

    public GraphDiagram addGraph(String graphId, String label) {
        Node newNode = this.root.getNodes().computeIfAbsent(graphId, k -> new DGraph().setId(graphId));
        newNode.setLabel(label);
        this.currentGraph = newNode.toGraph();
        return this;
    }

    public GraphDiagram addNode(String nodeId, String label) {
        Node newNode = this.currentGraph.getNodes().computeIfAbsent(nodeId, k -> new Node().setId((String)k));
        newNode.setLabel(label);
        return this;
    }

    public GraphDiagram addNode(String nodeId, String label, String attrText) {
        this.addNode(nodeId, label);
        this.addAttrText(nodeId, attrText);
        return this;
    }

    public GraphDiagram addAttrText(String nodeId, String attrText) {
        Node newNode = this.currentGraph.getNodes().computeIfAbsent(nodeId, k -> new Node().setId((String)k));
        newNode.setAttrText(attrText);
        return this;
    }

    public GraphDiagram addHref(String nodeId, String href) {
        Node newNode = this.currentGraph.getNodes().computeIfAbsent(nodeId, k -> new Node().setId((String)k));
        newNode.setHref(href);
        return this;
    }

    public GraphDiagram addEdge(String srcId, String srcLabel, String tgtId, String tgtLabel) {
        for (Edge edge : this.edges) {
            if (Objects.equals(srcId, edge.getSrcId()) && Objects.equals(srcLabel, edge.getSrcLabel()) && Objects.equals(tgtId, edge.getTgtId()) && Objects.equals(tgtLabel, edge.getTgtLabel())) {
                return this;
            }
            if (Objects.equals(srcId, edge.getSrcId()) && Objects.equals(srcLabel, edge.getSrcLabel()) && Objects.equals(tgtId, edge.getTgtId()) && edge.getTgtLabel() == null) {
                edge.setTgtLabel(tgtLabel);
                return this;
            }
            if (Objects.equals(srcId, edge.getTgtId()) && Objects.equals(srcLabel, edge.getTgtLabel()) && Objects.equals(tgtId, edge.getSrcId()) && Objects.equals(tgtLabel, edge.getSrcLabel())) {
                return this;
            }
            if (!Objects.equals(srcId, edge.getTgtId()) || !Objects.equals(srcLabel, edge.getTgtLabel()) || !Objects.equals(tgtId, edge.getSrcId()) || tgtLabel != null) continue;
            return this;
        }
        Edge newEdge = new Edge().setSrcId(srcId).setSrcLabel(srcLabel).setTgtId(tgtId).setTgtLabel(tgtLabel);
        this.edges.add(newEdge);
        return this;
    }

    public DGraph getRoot() {
        return this.root;
    }

    public GraphDiagram setRoot(DGraph root) {
        this.root = root;
        return this;
    }

    public DGraph getCurrentGraph() {
        return this.currentGraph;
    }
}

