/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fulib.Fulib;
import org.fulib.FulibTools;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.ClassModel;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.generators.DiagramGenerator;
import org.fulib.workflows.generators.FxmlGenerator;
import org.fulib.workflows.generators.HtmlGenerator;
import org.fulib.workflows.yaml.OwnYamlParser;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlObject;

public class BoardGenerator {
    private DiagramGenerator diagramGenerator;
    private FxmlGenerator fxmlGenerator;
    private HtmlGenerator htmlGenerator;
    private boolean webGeneration = false;
    private String genDir = "tmp";

    public void generateBoardFromFile(Path yamlFile) {
        try {
            String yamlContent = Files.readString(yamlFile);
            this.generateBoardFromString(yamlContent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateBoardFromString(String yamlContent) {
        Board board = this.generateBoard(yamlContent);
        this.diagramGenerator = new DiagramGenerator(this);
        this.fxmlGenerator = new FxmlGenerator(this);
        this.htmlGenerator = new HtmlGenerator(board, this);
        this.htmlGenerator.buildAndGenerateHTML(board);
        this.diagramGenerator.buildAndGenerateDiagram(board);
        this.fxmlGenerator.buildAndGenerateFxmls(board);
    }

    public Map<String, String> generateAndReturnHTMLsFromFile(Path yamlFile) {
        try {
            String inputStream = Files.readString(yamlFile);
            Board board = this.generateBoard(inputStream);
            this.diagramGenerator = new DiagramGenerator(this);
            this.fxmlGenerator = new FxmlGenerator(this);
            this.htmlGenerator = new HtmlGenerator(board, this);
            return this.buildAndReturnFiles(board);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> generateAndReturnHTMLsFromString(String yamlContent) {
        Board board = this.generateBoard(yamlContent);
        this.diagramGenerator = new DiagramGenerator(this);
        this.fxmlGenerator = new FxmlGenerator(this);
        this.htmlGenerator = new HtmlGenerator(board, this);
        return this.buildAndReturnFiles(board);
    }

    private Map<String, String> buildAndReturnFiles(Board board) {
        Map<String, String> result = new HashMap<String, String>();
        Map<String, String> boardAndPages = this.htmlGenerator.buildHTMLs(board);
        result = this.mergeMaps(result, boardAndPages);
        Map<String, String> diagrams = this.diagramGenerator.buildDiagrams(board);
        result = this.mergeMaps(result, diagrams);
        Map<String, String> fxmls = this.fxmlGenerator.buildFxmls(board);
        result = this.mergeMaps(result, fxmls);
        return result;
    }

    private Map<String, String> mergeMaps(Map<String, String> mainMap, Map<String, String> toBeMerged) {
        HashMap<String, String> result = new HashMap<String, String>(mainMap);
        toBeMerged.forEach((key, value) -> result.merge((String)key, (String)value, (v1, v2) -> ""));
        return result;
    }

    private Board generateBoard(String yamlContent) {
        OwnYamlParser ownYamlParser = new OwnYamlParser();
        ownYamlParser.parseYAML(yamlContent);
        return ownYamlParser.getBoard();
    }

    public boolean isWebGeneration() {
        return this.webGeneration;
    }

    public BoardGenerator setWebGeneration(boolean webGeneration) {
        this.webGeneration = webGeneration;
        return this;
    }

    public String getGenDir() {
        return this.genDir;
    }

    public BoardGenerator setGenDir(String genDir) {
        this.genDir = genDir;
        return this;
    }

    public void generateClassCode(String path, String packageName) {
        Set<Map.Entry<String, ClassModelManager>> entrySet = this.diagramGenerator.getClassDiagramMap().entrySet();
        for (Map.Entry<String, ClassModelManager> entry : entrySet) {
            String diagramName = entry.getKey();
            ClassModelManager mm = entry.getValue();
            ClassModel classModel = mm.getClassModel();
            classModel.setMainJavaDir(path).setPackageName(packageName);
            Fulib.generator().generate(classModel);
            FulibTools.classDiagrams().dumpSVG(classModel, String.format("%s/%s/classDiag.svg", path, packageName.replaceAll("\\.", "/")));
        }
    }

    public Map<String, Object> loadObjectStructure(String packageName, String service) {
        Object obj;
        Reflector reflector;
        String type;
        String id;
        Map<String, Map<String, YamlObject>> objectListMap = this.diagramGenerator.getObjectListMap();
        Map<String, YamlObject> serviceGraph = objectListMap.get(service);
        Collection<YamlObject> values = serviceGraph.values();
        ReflectorMap reflectorMap = new ReflectorMap(packageName);
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        for (YamlObject yamlObject : values) {
            id = yamlObject.getId();
            type = yamlObject.getType();
            reflector = reflectorMap.getReflector(type);
            obj = reflector.newInstance();
            reflector.setValue(obj, "name", (Object)id);
            objMap.put(id, obj);
        }
        for (YamlObject yamlObject : values) {
            id = yamlObject.getId();
            type = yamlObject.getType();
            reflector = reflectorMap.getReflector(type);
            obj = objMap.get(id);
            for (Map.Entry entry : yamlObject.getProperties().entrySet()) {
                String prop = (String)entry.getKey();
                Object value = entry.getValue();
                if (prop.equals(".id") || prop.equals("type")) continue;
                if (value instanceof Collection) {
                    ArrayList valueList = (ArrayList)value;
                    for (YamlObject yamlValue : valueList) {
                        Object tgt = objMap.get(yamlValue.getId());
                        reflector.setValue(obj, prop, tgt);
                    }
                    continue;
                }
                reflector.setValue(obj, prop, value);
            }
        }
        return objMap;
    }
}

