/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Div;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.generators.BoardGenerator;
import org.fulib.workflows.generators.constructors.BoardConstructor;
import org.fulib.workflows.generators.constructors.PageConstructor;

public class HtmlGenerator {
    private final Map<String, Integer> allPagesMap = new HashMap<String, Integer>();
    private final Map<String, Page> divPageMap = new LinkedHashMap<String, Page>();
    private BoardGenerator boardGenerator;

    HtmlGenerator(Board board, BoardGenerator boardGenerator) {
        this.createAllPagesMap(board);
        this.boardGenerator = boardGenerator;
    }

    public void buildAndGenerateHTML(Board board) {
        Map<String, String> generatedHTMLs = this.buildHTMLs(board);
        for (String key : generatedHTMLs.keySet()) {
            if (key.equals("Board")) {
                this.generateHTML(generatedHTMLs.get(key), key, "");
                continue;
            }
            this.generateHTML(generatedHTMLs.get(key), key, "pages/");
        }
    }

    public Map<String, String> buildHTMLs(Board board) {
        BoardConstructor boardConstructor = new BoardConstructor();
        PageConstructor pageConstructor = new PageConstructor();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String htmlBoard = boardConstructor.buildBoard(board, this.boardGenerator.isWebGeneration());
        resultMap.put("Board", htmlBoard);
        ArrayList<String> pagesHTML = new ArrayList<String>();
        Page lastPage = null;
        for (Workflow workflow : board.getWorkflows()) {
            for (BaseNote note : workflow.getNotes()) {
                List<Integer> targetPageIndexList;
                String lastPageContent;
                if (note instanceof Page) {
                    Page page;
                    lastPage = page = (Page)note;
                    List<Integer> targetPageIndexList2 = this.evaluateTargetPageIndex(page);
                    String pageContent = pageConstructor.buildPage(page, targetPageIndexList2, this.divPageMap, this.boardGenerator.isWebGeneration());
                    if (pageContent != null) {
                        pagesHTML.add(pageContent);
                    }
                }
                if (!(note instanceof Div)) continue;
                Div div = (Div)note;
                Page divPage = new Page();
                divPage.setName(div.getName());
                divPage.setIndex(div.getIndex());
                divPage.setContent(div.getContent());
                this.divPageMap.put(div.getName(), divPage);
                if (lastPage == null || (lastPageContent = pageConstructor.buildPage(lastPage, targetPageIndexList = this.evaluateTargetPageIndex(lastPage), this.divPageMap, this.boardGenerator.isWebGeneration())) == null) continue;
                pagesHTML.add(lastPageContent);
            }
        }
        for (int i = 0; i < pagesHTML.size(); ++i) {
            String page = (String)pagesHTML.get(i);
            resultMap.put(i + "_page", page);
        }
        return resultMap;
    }

    private List<Integer> evaluateTargetPageIndex(Page page) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < page.getContent().size(); ++i) {
            String targetPageName;
            Integer targetIndex;
            Pair<String, String> elementPair = page.getContent().get(i);
            if (!((String)elementPair.a).equals("targetPage") || (targetIndex = this.allPagesMap.get(targetPageName = (String)elementPair.b)) == null) continue;
            result.add(targetIndex);
        }
        return result;
    }

    private void generateHTML(String htmlContent, String fileName, String subFolder) {
        try {
            String outputDirectory = this.boardGenerator.getGenDir() + "/" + subFolder;
            Files.createDirectories(Path.of(outputDirectory, new String[0]), new FileAttribute[0]);
            String outputBoardFilePath = outputDirectory + fileName + ".html";
            Path outputPath = Path.of(outputBoardFilePath, new String[0]);
            if (!Files.exists(outputPath, new LinkOption[0])) {
                Files.createFile(outputPath, new FileAttribute[0]);
            }
            Files.writeString(outputPath, (CharSequence)htmlContent, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createAllPagesMap(Board board) {
        int index = 0;
        for (Workflow workflow : board.getWorkflows()) {
            for (BaseNote note : workflow.getNotes()) {
                if (!(note instanceof Page)) continue;
                Page page = (Page)note;
                this.allPagesMap.put(page.getName(), index);
                ++index;
            }
        }
    }
}

