/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fulib.FulibTools;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.yaml.YamlObject;

public class ClassDiagramConstructor {
    private final Map<String, Clazz> clazzMap = new HashMap<String, Clazz>();
    private Map<String, YamlObject> yamlGraph;
    private ClassModelManager mm;

    public ClassModelManager getMm() {
        return this.mm;
    }

    public String buildClassDiagram(Map<String, YamlObject> yamlGraph) {
        this.yamlGraph = yamlGraph;
        this.mm = new ClassModelManager();
        this.createClazz(this.mm);
        for (YamlObject yamlObject : yamlGraph.values()) {
            if (yamlObject.getType() == null) continue;
            Clazz myClass = this.mm.haveClass(yamlObject.getType());
            this.mm.haveAttribute(myClass, "name", "String");
            for (Map.Entry entry : yamlObject.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key.contains(".")) continue;
                YamlObject yamlValue = this.getOneYamlValue(value);
                if (yamlValue != null && yamlValue.getType() != null) {
                    Clazz valueClass = this.mm.haveClass(yamlValue.getType());
                    int valueSize = this.getSize(value);
                    Map.Entry<String, Object> revEntry = this.findReverseReference(yamlValue, yamlObject);
                    if (revEntry == null) continue;
                    String revKey = revEntry.getKey();
                    Object revValue = revEntry.getValue();
                    YamlObject revYamlObject = this.getOneYamlValue(revValue);
                    int revSize = this.getSize(revValue);
                    try {
                        this.mm.haveRole(myClass, key, valueSize, valueClass, revKey, revSize);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (key.startsWith(".") || key.equals("type")) continue;
                String type = this.learnTypeFromValue(value);
                try {
                    this.mm.haveAttribute(myClass, key, type);
                }
                catch (Exception exception) {}
            }
        }
        String classDiagramString = this.generateClassDiagram(this.mm.getClassModel());
        if (this.mm.getClassModel().getClasses().size() > 0) {
            return classDiagramString;
        }
        return null;
    }

    private String learnTypeFromValue(Object value) {
        try {
            Integer.parseInt(value.toString());
            return "int";
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(value.toString().replace(',', '.'));
                return "double";
            }
            catch (Exception exception2) {
                return "String";
            }
        }
    }

    private YamlObject getOneYamlValue(Object value) {
        if (value instanceof Collection) {
            Collection set = (Collection)value;
            return (YamlObject)set.toArray()[0];
        }
        if (value instanceof YamlObject) {
            YamlObject yamlValue = (YamlObject)value;
            return yamlValue;
        }
        return null;
    }

    private int getSize(Object value) {
        if (value instanceof Collection) {
            return 42;
        }
        if (value instanceof YamlObject) {
            return 1;
        }
        return 0;
    }

    private Map.Entry<String, Object> findReverseReference(YamlObject yamlTgt, YamlObject yamlObject) {
        for (Map.Entry<String, Object> entry : yamlTgt.getProperties().entrySet()) {
            YamlObject yamlValue;
            Object v = entry.getValue();
            if (v instanceof Collection) {
                Collection revCollection = (Collection)v;
                if (revCollection.contains(yamlObject)) {
                    return entry;
                }
                if (entry.getValue() != yamlObject) continue;
                return entry;
            }
            v = entry.getValue();
            if (!(v instanceof YamlObject) || (yamlValue = (YamlObject)v) != yamlObject) continue;
            return entry;
        }
        return null;
    }

    private void createClazz(ClassModelManager mm) {
        for (YamlObject object : this.yamlGraph.values()) {
            if (object.getType() == null) continue;
            String className = object.getType();
            this.clazzMap.put(className.toLowerCase(), mm.haveClass(className));
        }
    }

    private String generateClassDiagram(ClassModel classModel) {
        String fileName = "genTmp/diagrams/classdiagram";
        String result = "";
        fileName = FulibTools.classDiagrams().withScale(2.0).dumpSVG(classModel, fileName);
        try {
            Path path = Path.of(fileName + ".svg", new String[0]);
            result = Files.readString(path);
            Files.deleteIfExists(path);
            Files.deleteIfExists(Path.of("genTmp/diagrams/", new String[0]));
            Files.deleteIfExists(Path.of("genTmp/", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

