/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.FulibTools;
import org.fulib.workflows.events.Data;
import org.fulib.yaml.YamlObject;

public class ObjectDiagramConstructor {
    public String buildObjectDiagram(List<Data> notes) {
        Map<String, YamlObject> yamlGraph = this.buildFulibGraphDiagram(notes);
        FulibTools.objectDiagrams().withScale(2.0).dumpSVG("./tmp/_yamlGraph.svg", new Object[]{yamlGraph.values()});
        try {
            return Files.readString(Path.of("./tmp/_yamlGraph.svg", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Map<String, YamlObject> buildFulibGraphDiagram(List<Data> notes) {
        String className;
        String objName;
        LinkedHashMap<String, YamlObject> yamlGraph = new LinkedHashMap<String, YamlObject>();
        for (Data data : notes) {
            objName = data.getName().split(" ")[1];
            className = data.getName().split(" ")[0];
            YamlObject yamlObject = yamlGraph.computeIfAbsent(objName, k -> new YamlObject(objName));
            yamlObject.setType(className);
        }
        for (Data data : notes) {
            objName = data.getName().split(" ")[1];
            className = data.getName().split(" ")[0];
            YamlObject yamlObj = yamlGraph.computeIfAbsent(objName, k -> new YamlObject(objName, className));
            Map<Integer, Pair<String, String>> objData = data.getData();
            for (Pair<String, String> pair : objData.values()) {
                String key = (String)pair.a;
                String value = (String)pair.b;
                if (value.startsWith("[")) {
                    String[] split;
                    value = value.substring(1, value.length() - 1);
                    for (String id : split = value.split(",")) {
                        id = id.trim();
                        YamlObject tgtObj = yamlGraph.computeIfAbsent(id, k -> new YamlObject(k));
                        yamlObj.with(key, (Object)tgtObj);
                    }
                    continue;
                }
                if (yamlGraph.get(value) == null) {
                    yamlObj.put(key, (Object)value);
                    continue;
                }
                yamlObj.put(key, yamlGraph.get(value));
            }
        }
        return yamlGraph;
    }
}

