/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.workflows.events.Page;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class PageConstructor {
    private Page currentPage;
    private Map<String, Page> divPageMap;
    private STGroupFile pageGroup;
    private boolean webGeneration;

    public String buildPage(Page page, List<Integer> targetPageIndexList, Map<String, Page> divPageMap, boolean webGeneration) {
        this.currentPage = page;
        this.divPageMap = divPageMap;
        this.webGeneration = webGeneration;
        this.initPageGroup();
        StringBuilder pageBody = new StringBuilder();
        ST st = this.pageGroup.getInstanceOf("page");
        String pageContent = this.buildPageContent(targetPageIndexList);
        if (pageContent == null) {
            return null;
        }
        st.add("content", (Object)pageContent);
        st.add("pageName", (Object)this.currentPage.getName());
        pageBody.append(st.render());
        return pageBody.toString();
    }

    private void initPageGroup() {
        if (this.pageGroup == null) {
            URL resource = PageConstructor.class.getResource("Page.stg");
            this.pageGroup = new STGroupFile(Objects.requireNonNull(resource));
        }
    }

    public String buildDivRow(Page page, List<Integer> targetPageIndexList, Map<String, Page> divPageMap) {
        this.currentPage = page;
        this.divPageMap = divPageMap;
        this.initPageGroup();
        String pageContent = this.buildPageContent(targetPageIndexList);
        return pageContent;
    }

    private String buildPageContent(List<Integer> targetPageIndexList) {
        StringBuilder contentBody = new StringBuilder();
        int targetIndex = 0;
        for (int i = 0; i <= this.currentPage.getContent().size(); ++i) {
            boolean complete;
            String key;
            if (this.currentPage.getContent().get(i) == null || (key = (String)this.currentPage.getContent().get((Object)Integer.valueOf((int)i)).a).equals("value") || key.equals("targetPage")) continue;
            String value = (String)this.currentPage.getContent().get((Object)Integer.valueOf((int)i)).b;
            Pair<String, String> nextElement = new Pair<String, String>((Object)"", (Object)"");
            if (i + 1 < this.currentPage.getContent().size()) {
                nextElement = this.currentPage.getContent().get(i + 1);
            }
            if (key.contains("text")) {
                this.buildText(contentBody, value);
                continue;
            }
            if (key.contains("input")) {
                this.buildInput(contentBody, i, value, nextElement);
                continue;
            }
            if (key.contains("password")) {
                this.buildPassword(contentBody, i, value, nextElement);
                continue;
            }
            if (key.contains("button")) {
                targetIndex = this.buildButton(targetPageIndexList, contentBody, targetIndex, value);
                continue;
            }
            if (!key.equals("div") || (complete = this.buildDivItems(targetPageIndexList, contentBody, value))) continue;
            return null;
        }
        return contentBody.toString();
    }

    private boolean buildDivItems(List<Integer> targetPageIndexList, StringBuilder contentBody, String value) {
        ST st = this.pageGroup.getInstanceOf("rowOfDiv");
        String[] split = this.stripBraces(value).split(",");
        if (this.divPageMap != null) {
            for (int i = 0; i < split.length; ++i) {
                String content;
                split[i] = split[i].trim();
                Page divPage = this.divPageMap.get(split[i]);
                if (divPage != null) {
                    content = new PageConstructor().buildDivRow(divPage, targetPageIndexList, this.divPageMap);
                    if (content == null) {
                        return false;
                    }
                } else {
                    return false;
                }
                split[i] = content;
            }
        }
        st.add("divList", (Object)split);
        String str = st.render();
        contentBody.append(str);
        return true;
    }

    private int buildButton(List<Integer> targetPageIndexList, StringBuilder contentBody, int targetIndex, String value) {
        ST st = this.webGeneration ? this.pageGroup.getInstanceOf("button") : this.pageGroup.getInstanceOf("buttonAlone");
        st.add("description", (Object)value);
        int foundTargetIndex = targetIndex < targetPageIndexList.size() ? targetPageIndexList.get(targetIndex).intValue() : this.currentPage.getIndex();
        st.add("targetIndex", (Object)foundTargetIndex);
        contentBody.append(st.render());
        return ++targetIndex;
    }

    private void buildPassword(StringBuilder contentBody, int i, String value, Pair<String, String> nextElement) {
        ST st = this.pageGroup.getInstanceOf("password");
        st.add("id", (Object)(i + "password"));
        st.add("label", (Object)value);
        st.add("value", (Object)this.getValue(nextElement));
        contentBody.append(st.render());
    }

    private void buildInput(StringBuilder contentBody, int i, String value, Pair<String, String> nextElement) {
        ST st = this.pageGroup.getInstanceOf("input");
        st.add("id", (Object)(i + "input"));
        st.add("label", (Object)value);
        st.add("value", (Object)this.getValue(nextElement));
        contentBody.append(st.render());
    }

    private void buildText(StringBuilder contentBody, String value) {
        ST st = this.pageGroup.getInstanceOf("text");
        if (value != null && value.startsWith("<pre>")) {
            st = this.pageGroup.getInstanceOf("pre");
        }
        st.add("text", (Object)value);
        String content = st.render();
        contentBody.append(content);
    }

    private String stripBraces(String value) {
        int pos = value.indexOf(91);
        if (pos >= 0) {
            value = value.substring(pos + 1);
        }
        if ((pos = value.indexOf(93)) >= 0) {
            value = value.substring(0, pos);
        }
        return value;
    }

    private String getValue(Pair<String, String> nextElement) {
        String result = "";
        if (((String)nextElement.a).equals("value")) {
            result = (String)nextElement.b;
        }
        return result;
    }
}

