/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Command;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.events.Develop;
import org.fulib.workflows.events.Div;
import org.fulib.workflows.events.Event;
import org.fulib.workflows.events.ExternalSystem;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Policy;
import org.fulib.workflows.events.Problem;
import org.fulib.workflows.events.Service;
import org.fulib.workflows.events.User;
import org.fulib.workflows.events.Workflow;
import org.fulib.workflows.utils.FulibWorkflowsLintError;
import org.fulib.workflows.utils.FulibWorkflowsParseError;
import org.yaml.snakeyaml.Yaml;

public class OwnYamlParser {
    private final Board board = new Board();
    private final Yaml yaml = new Yaml();
    private int workflowIndex = 0;
    private Workflow currentWorkflow;
    private final List<Workflow> workflows = new ArrayList<Workflow>();
    private int noteIndex = 0;
    private BaseNote currentNote;
    private List<BaseNote> notes = new ArrayList<BaseNote>();
    private int dataIndex = 0;
    private Map<Integer, Pair<String, String>> noteData = new HashMap<Integer, Pair<String, String>>();

    public void parseYAML(String yamlInput) {
        boolean lintSuccessfully = this.lintInput(yamlInput = this.cleanUpInput(yamlInput));
        if (!lintSuccessfully) {
            return;
        }
        List loadedEvents = (List)this.yaml.load(yamlInput);
        for (Object loadedEvent : loadedEvents) {
            if (!(loadedEvent instanceof Map)) {
                try {
                    throw new FulibWorkflowsParseError("Notes must be an object");
                }
                catch (FulibWorkflowsParseError e) {
                    e.printStackTrace();
                    continue;
                }
            }
            Map singleEventMap = (Map)loadedEvent;
            for (Map.Entry entry : singleEventMap.entrySet()) {
                String key = (String)entry.getKey();
                BaseNote newNote = this.evaluateCurrentNote(key);
                if (newNote != null) {
                    newNote.setIndex(this.noteIndex);
                    ++this.noteIndex;
                    if (key.equals("page") || key.equals("div") || key.equals("develop")) {
                        this.parsePageEntries(entry.getValue());
                        continue;
                    }
                    newNote.setName((String)entry.getValue());
                    continue;
                }
                this.addNewNoteData(key, entry.getValue());
            }
        }
        if (this.currentNote != null) {
            this.setExtendedNote();
        }
        this.setWorkflow();
        this.board.setWorkflows(this.workflows);
    }

    private void parsePageEntries(Object value) {
        if (!(value instanceof List)) {
            this.printStackTraceFor("Page entries must be a list");
            return;
        }
        List pageEntryMaps = (List)value;
        for (HashMap pageEntryMap : pageEntryMaps) {
            for (Map.Entry pageEntry : pageEntryMap.entrySet()) {
                String key = (String)pageEntry.getKey();
                if (key.equals("pageName") || key.equals("divName")) {
                    this.currentNote.setName((String)pageEntry.getValue());
                }
                this.addNewNoteData(key, pageEntry.getValue());
            }
        }
        BaseNote baseNote = this.currentNote;
        if (baseNote instanceof Page) {
            Page page = (Page)baseNote;
            page.setContent(this.noteData);
            this.noteData = new HashMap<Integer, Pair<String, String>>();
            this.noteIndex = 0;
            this.dataIndex = 0;
            this.currentNote = null;
        } else {
            baseNote = this.currentNote;
            if (baseNote instanceof Div) {
                Div page = (Div)baseNote;
                page.setContent(this.noteData);
                this.noteData = new HashMap<Integer, Pair<String, String>>();
                this.noteIndex = 0;
                this.dataIndex = 0;
                this.currentNote = null;
            } else {
                baseNote = this.currentNote;
                if (baseNote instanceof Develop) {
                    Develop page = (Develop)baseNote;
                    page.setContent(this.noteData);
                    this.noteData = new HashMap<Integer, Pair<String, String>>();
                    this.noteIndex = 0;
                    this.dataIndex = 0;
                    this.currentNote = null;
                }
            }
        }
    }

    private void printStackTraceFor(String message) {
        try {
            throw new FulibWorkflowsParseError(message);
        }
        catch (FulibWorkflowsParseError e) {
            e.printStackTrace();
            return;
        }
    }

    private void addNewNoteData(String key, Object value) {
        String valueAsString = this.evaluateValueAsString(value);
        this.noteData.put(this.dataIndex, (Pair<String, String>)new Pair((Object)key, (Object)valueAsString));
        ++this.dataIndex;
    }

    private BaseNote evaluateCurrentNote(String key) {
        switch (key) {
            case "workflow": {
                if (this.currentWorkflow != null) {
                    this.setWorkflow();
                }
                Workflow workflow = new Workflow();
                workflow.setIndex(this.workflowIndex);
                ++this.workflowIndex;
                this.workflows.add(workflow);
                this.currentWorkflow = workflow;
                return workflow;
            }
            case "externalSystem": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                ExternalSystem externalSystem = new ExternalSystem();
                externalSystem.setIndex(this.noteIndex);
                ++this.noteIndex;
                this.notes.add(externalSystem);
                return externalSystem;
            }
            case "service": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Service service = new Service();
                this.notes.add(service);
                return service;
            }
            case "command": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Command command = new Command();
                this.notes.add(command);
                return command;
            }
            case "event": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Event event = new Event();
                this.notes.add(event);
                this.currentNote = event;
                return event;
            }
            case "policy": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Policy policy = new Policy();
                this.notes.add(policy);
                return policy;
            }
            case "user": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                User user = new User();
                this.notes.add(user);
                return user;
            }
            case "data": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Data data = new Data();
                this.notes.add(data);
                this.currentNote = data;
                return data;
            }
            case "page": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Page page = new Page();
                this.notes.add(page);
                this.currentNote = page;
                return page;
            }
            case "div": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Div page = new Div();
                this.notes.add(page);
                this.currentNote = page;
                return page;
            }
            case "develop": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Develop develop = new Develop();
                this.notes.add(develop);
                this.currentNote = develop;
                return develop;
            }
            case "problem": {
                if (this.currentNote != null) {
                    this.setExtendedNote();
                }
                Problem problem = new Problem();
                this.notes.add(problem);
                return problem;
            }
        }
        return null;
    }

    private void setExtendedNote() {
        BaseNote baseNote = this.currentNote;
        if (baseNote instanceof Data) {
            Data data = (Data)baseNote;
            data.setData(this.noteData);
        } else {
            baseNote = this.currentNote;
            if (baseNote instanceof Event) {
                Event event = (Event)baseNote;
                event.setData(this.noteData);
            } else {
                try {
                    throw new FulibWorkflowsParseError("Additional attributes only allowed for data and event notes");
                }
                catch (FulibWorkflowsParseError e) {
                    e.printStackTrace();
                }
            }
        }
        this.noteData = new HashMap<Integer, Pair<String, String>>();
        this.dataIndex = 0;
        this.currentNote = null;
    }

    private void setWorkflow() {
        this.currentWorkflow.setNotes(this.notes);
        this.notes = new ArrayList<BaseNote>();
        this.noteIndex = 0;
    }

    public Board getBoard() {
        return this.board;
    }

    private String evaluateValueAsString(Object value) {
        String valueType = value.getClass().getSimpleName();
        String valueAsString = "";
        int valueAsInt = -1;
        List valueAsArrayList = null;
        switch (valueType) {
            case "String": {
                valueAsString = (String)value;
                break;
            }
            case "Integer": {
                valueAsInt = (Integer)value;
                break;
            }
            case "ArrayList": {
                valueAsArrayList = (List)value;
            }
        }
        if (!valueAsString.equals("")) {
            return valueAsString;
        }
        if (valueAsInt != -1) {
            return String.valueOf(valueAsInt);
        }
        if (valueAsArrayList != null) {
            return valueAsArrayList.toString();
        }
        try {
            throw new FulibWorkflowsParseError("Attribute value must be String or Integer");
        }
        catch (FulibWorkflowsParseError e) {
            e.printStackTrace();
            return null;
        }
    }

    private String cleanUpInput(String yamlInput) {
        return yamlInput.replaceAll("\\t", "  ");
    }

    private boolean lintInput(String yamlInput) {
        if (!yamlInput.contains("- workflow: ")) {
            try {
                throw new FulibWorkflowsLintError("Needs at least on workflow note (best at the beginning)");
            }
            catch (FulibWorkflowsLintError e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

