/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.YamlObject;
import org.fulib.yaml.YamlObjectReflector;

public class ReflectorMap {
    private Map<String, Reflector> reflectorMap = new LinkedHashMap<String, Reflector>();
    private final Collection<String> packageNames;
    private Class<?> eObject;

    public ReflectorMap(String packageName) {
        this(Collections.singleton(packageName));
    }

    public ReflectorMap(String ... packageNames) {
        this(Arrays.asList(packageNames));
    }

    public ReflectorMap(Collection<String> packageNames) {
        this.packageNames = packageNames;
        try {
            this.eObject = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.emf.ecore.EObject");
            Logger.getGlobal().log(Level.INFO, "could load org.eclipse.emf.ecore.EObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Deprecated
    public ReflectorMap(ArrayList<String> packageNames) {
        this((Collection<String>)packageNames);
    }

    public Set<Object> discoverObjects(Object root) {
        HashSet<Object> neighbors = new HashSet<Object>();
        this.discoverObjects(root, neighbors);
        return neighbors;
    }

    public Set<Object> discoverObjects(Object ... roots) {
        HashSet<Object> neighbors = new HashSet<Object>();
        this.discoverObjects(roots, (Set<Object>)neighbors);
        return neighbors;
    }

    public Set<Object> discoverObjects(Collection<?> roots) {
        HashSet<Object> neighbors = new HashSet<Object>();
        this.discoverObjects(roots, neighbors);
        return neighbors;
    }

    public void discoverObjects(Object root, Set<Object> out) {
        if (root == null) {
            return;
        }
        if (root instanceof Collection) {
            this.discoverObjects((Collection)root, out);
            return;
        }
        if (root instanceof Object[]) {
            this.discoverObjects((Object[])root);
            return;
        }
        if (!this.canReflect(root) || !out.add(root)) {
            return;
        }
        Reflector reflector = this.getReflector(root);
        for (String property : reflector.getAllProperties()) {
            Object value = reflector.getValue(root, property);
            this.discoverObjects(value, out);
        }
    }

    public void discoverObjects(Object[] roots, Set<Object> out) {
        for (Object root : roots) {
            this.discoverObjects(root, out);
        }
    }

    public void discoverObjects(Collection<?> roots, Set<Object> out) {
        for (Object item : roots) {
            this.discoverObjects(item, out);
        }
    }

    public boolean canReflect(Object object) {
        return object != null && this.canReflect(object.getClass());
    }

    public boolean canReflect(Class<?> type) {
        return this.canReflect(type.getPackage()) || YamlObject.class.isAssignableFrom(type);
    }

    public boolean canReflect(Package thePackage) {
        return thePackage != null && this.canReflect(thePackage.getName());
    }

    private boolean canReflect(String packageName) {
        return this.packageNames.contains(packageName);
    }

    public Reflector getReflector(Object object) {
        if (object instanceof YamlObject) {
            return new YamlObjectReflector((YamlObject)object);
        }
        return this.getReflector(object.getClass());
    }

    public Reflector getReflector(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        String fullName = clazz.getName();
        if (!this.packageNames.contains(packageName)) {
            throw this.unknownClassException(fullName);
        }
        String simpleName = clazz.getSimpleName();
        return this.reflectorMap.computeIfAbsent(simpleName, k -> new Reflector().setClassName(fullName).setClazz(clazz));
    }

    public Reflector getReflector(String simpleName) {
        return this.reflectorMap.computeIfAbsent(simpleName, this::createReflector);
    }

    private Reflector createReflector(String simpleName) {
        for (String packageName : this.packageNames) {
            String fullClassName = packageName + "." + simpleName;
            try {
                Class<?> theClass = Class.forName(fullClassName);
                return new Reflector().setClassName(fullClassName).setClazz(theClass);
            }
            catch (ClassNotFoundException theClass) {
                if (this.eObject == null) continue;
                try {
                    String implClassName = packageName + ".impl." + simpleName;
                    Class<?> implClass = Class.forName(implClassName);
                    return new Reflector().setClassName(implClassName).setClazz(implClass).setUseEMF();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        throw this.unknownClassException(simpleName);
    }

    private RuntimeException unknownClassException(String className) {
        StringBuilder message = new StringBuilder();
        message.append("ReflectorMap could not find class description for ").append(className).append("\nsearching in \n");
        for (String name : this.packageNames) {
            message.append("   ").append(name).append("\n");
        }
        message.append("You might add more packages to the construction of the ReflectorMap / YamlIdMap \nor you might move the missing class into the common model package.");
        return new RuntimeException(message.toString());
    }
}

