/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.yaml.StrUtil;

public class Reflector {
    private String className = "";
    private Method emfCreateMethod;
    private Object emfFactory;
    private Class<?> eObjectClass;
    private Class<?> clazz;
    private transient Set<String> ownProperties;
    private transient Set<String> allProperties;

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.clazz;
    }

    public Reflector setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public Reflector setClassName(String className) {
        this.className = className;
        return this;
    }

    public Reflector setUseEMF() {
        String packageName = this.className;
        int pos = packageName.lastIndexOf(46);
        String simpleClassName = packageName.substring(pos + 1);
        simpleClassName = simpleClassName.substring(0, simpleClassName.length() - "Impl".length());
        packageName = packageName.substring(0, pos);
        packageName = packageName.substring(0, packageName.length() - ".impl".length());
        pos = packageName.lastIndexOf(46);
        String lastPart = packageName.substring(pos + 1);
        String simpleFactoryName = StrUtil.cap(lastPart) + "Factory";
        try {
            Class<?> factoryClass = Class.forName(packageName + "." + simpleFactoryName);
            Field eInstanceField = factoryClass.getField("eINSTANCE");
            this.emfFactory = eInstanceField.get(null);
            this.emfCreateMethod = this.emfFactory.getClass().getMethod("create" + simpleClassName, new Class[0]);
            this.eObjectClass = Class.forName("org.eclipse.emf.ecore.EObject");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "could not find EMF Factory createXY method", e);
        }
        return this;
    }

    @Deprecated
    public String[] getProperties() {
        return this.getOwnProperties().toArray(new String[0]);
    }

    public Set<String> getOwnProperties() {
        if (this.ownProperties != null) {
            return this.ownProperties;
        }
        TreeSet<String> ownProperties = new TreeSet<String>();
        Reflector.addOwnProperties(this.getClazz(), ownProperties);
        this.ownProperties = Collections.unmodifiableSet(ownProperties);
        return this.ownProperties;
    }

    public Set<String> getAllProperties() {
        if (this.allProperties != null) {
            return this.allProperties;
        }
        TreeSet<String> ownProperties = new TreeSet<String>();
        Reflector.addAllProperties(this.getClazz(), ownProperties);
        this.allProperties = Collections.unmodifiableSet(ownProperties);
        return this.allProperties;
    }

    private static void addOwnProperties(Class<?> clazz, Set<String> fieldNames) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getParameterCount() != 0 || methodName.length() <= 3 || !methodName.startsWith("get") || "getClass".equals(methodName)) continue;
            String attributeName = StrUtil.downFirstChar(methodName.substring(3));
            fieldNames.add(attributeName);
        }
    }

    private static void addAllProperties(Class<?> clazz, Set<String> fieldNames) {
        Reflector.addOwnProperties(clazz, fieldNames);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            Reflector.addAllProperties(superClass, fieldNames);
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            Reflector.addAllProperties(superInterface, fieldNames);
        }
    }

    public Object newInstance() {
        try {
            if (this.emfCreateMethod != null) {
                return this.emfCreateMethod.invoke(this.emfFactory, new Object[0]);
            }
            Class<?> clazz = this.getClazz();
            return clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getValue(Object object, String attribute) {
        if (object == null) {
            return null;
        }
        String capName = StrUtil.cap(attribute);
        Class<?> clazz = this.getClazz();
        try {
            return clazz.getMethod("get" + capName, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            try {
                return clazz.getMethod(attribute, new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception2) {
                try {
                    return clazz.getMethod("is" + capName, new Class[0]).invoke(object, new Object[0]);
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }

    @Deprecated
    public Object setValue(Object object, String attribute, Object value, String type) {
        return this.setValue(object, attribute, value);
    }

    public Object setValue(Object object, String attribute, Object value) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = this.getClazz();
        String capName = StrUtil.cap(attribute);
        String setterName = "set" + capName;
        try {
            Class<?> valueClass = value.getClass();
            if (this.eObjectClass != null && this.eObjectClass.isAssignableFrom(valueClass)) {
                valueClass = valueClass.getInterfaces()[0];
            }
            Method method = clazz.getMethod(setterName, valueClass);
            return method.invoke(object, value);
        }
        catch (Exception valueClass) {
            try {
                int intValue = Integer.parseInt((String)value);
                Method method = clazz.getMethod(setterName, Integer.TYPE);
                return method.invoke(object, intValue);
            }
            catch (Exception intValue) {
                try {
                    long longValue = Long.parseLong((String)value);
                    Method method = clazz.getMethod(setterName, Long.TYPE);
                    return method.invoke(object, longValue);
                }
                catch (Exception longValue) {
                    try {
                        double doubleValue = Double.parseDouble((String)value);
                        Method method = clazz.getMethod(setterName, Double.TYPE);
                        return method.invoke(object, doubleValue);
                    }
                    catch (Exception doubleValue) {
                        try {
                            float floatValue = Float.parseFloat((String)value);
                            Method method = clazz.getMethod(setterName, Float.TYPE);
                            return method.invoke(object, Float.valueOf(floatValue));
                        }
                        catch (Exception floatValue) {
                            try {
                                Method method = clazz.getMethod("with" + capName, Object[].class);
                                return method.invoke(object, new Object[]{new Object[]{value}});
                            }
                            catch (Exception method) {
                                if (this.emfCreateMethod != null) {
                                    try {
                                        Method getMethod = clazz.getMethod("get" + capName, new Class[0]);
                                        Object collection = getMethod.invoke(object, new Object[0]);
                                        Method addMethod = collection.getClass().getMethod("add", Object.class);
                                        return addMethod.invoke(collection, value);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    public void removeObject(Object object) {
        try {
            Class<?> clazz = this.getClazz();
            Method removeYou = clazz.getMethod("removeYou", new Class[0]);
            removeYou.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

