/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.yaml.EventSource;
import org.fulib.yaml.YamlGenerator;

public class EventFiler {
    private final EventSource eventSource;
    private String historyFileName = null;

    public EventFiler(EventSource eventSource) {
        this.eventSource = eventSource;
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public EventFiler setHistoryFileName(String historyFileName) {
        this.historyFileName = historyFileName;
        return this;
    }

    public String loadHistory() {
        Path historyFile = Paths.get(this.historyFileName, new String[0]);
        if (Files.exists(historyFile, new LinkOption[0])) {
            return null;
        }
        try {
            return new String(Files.readAllBytes(historyFile));
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean storeHistory() {
        Path historyFile = Paths.get(this.historyFileName, new String[0]);
        EventFiler.createDirs(historyFile);
        try (BufferedWriter writer = Files.newBufferedWriter(historyFile, StandardOpenOption.CREATE);){
            this.eventSource.encodeYaml(writer);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "could not write to historyFile " + historyFile, e);
            return false;
        }
        return true;
    }

    public EventFiler startEventLogging() {
        this.eventSource.addEventListener(this::storeEvent);
        return this;
    }

    @Deprecated
    public void storeEvent(LinkedHashMap<String, String> event) {
        this.storeEvent((Map<String, String>)event);
    }

    public void storeEvent(Map<String, String> event) {
        Path historyFile = Paths.get(this.historyFileName, new String[0]);
        EventFiler.createDirs(historyFile);
        try (BufferedWriter writer = Files.newBufferedWriter(historyFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            YamlGenerator.serialize(event, (Appendable)writer);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "could not write to historyFile " + historyFile, e);
        }
    }

    private static void createDirs(Path historyFile) {
        try {
            Files.createDirectories(historyFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "could create directories for historyFile " + historyFile, e);
        }
    }
}

