/*
 * Decompiled with CFR 0.152.
 */
package org.furyio.serialization.dubbo;

import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassChecker;
import io.fury.serializer.SerializerFactory;
import io.fury.util.LoaderBinding;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.furyio.serialization.dubbo.FuryCheckerListener;
import org.furyio.serialization.dubbo.FuryObjectInput;
import org.furyio.serialization.dubbo.FuryObjectOutput;

public abstract class BaseFurySerialization
implements Serialization {
    protected abstract Tuple2<LoaderBinding, MemoryBuffer> getFury();

    public ObjectOutput serialize(URL url, OutputStream output) throws IOException {
        Tuple2<LoaderBinding, MemoryBuffer> tuple2 = this.getFury();
        ((LoaderBinding)tuple2.f0).setClassLoader(Thread.currentThread().getContextClassLoader());
        Fury fury = ((LoaderBinding)tuple2.f0).get();
        FuryCheckerListener checkerListener = BaseFurySerialization.getCheckerListener(url);
        fury.getClassResolver().setClassChecker((ClassChecker)checkerListener.getChecker());
        fury.getClassResolver().setSerializerFactory((SerializerFactory)checkerListener);
        return new FuryObjectOutput(fury, (MemoryBuffer)tuple2.f1, output);
    }

    public ObjectInput deserialize(URL url, InputStream input) throws IOException {
        Tuple2<LoaderBinding, MemoryBuffer> tuple2 = this.getFury();
        ((LoaderBinding)tuple2.f0).setClassLoader(Thread.currentThread().getContextClassLoader());
        Fury fury = ((LoaderBinding)tuple2.f0).get();
        FuryCheckerListener checkerListener = BaseFurySerialization.getCheckerListener(url);
        fury.getClassResolver().setClassChecker((ClassChecker)checkerListener.getChecker());
        return new FuryObjectInput(fury, (MemoryBuffer)tuple2.f1, input);
    }

    private static FuryCheckerListener getCheckerListener(URL url) {
        return (FuryCheckerListener)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(FuryCheckerListener.class);
    }
}

