/*
 * Decompiled with CFR 0.152.
 */
package org.furyio.serialization.dubbo;

import io.fury.Fury;
import io.fury.exception.InsecureException;
import io.fury.resolver.AllowListChecker;
import io.fury.serializer.Serializer;
import io.fury.serializer.SerializerFactory;
import java.io.Serializable;
import java.util.Set;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class FuryCheckerListener
implements AllowClassNotifyListener,
SerializerFactory {
    private final SerializeSecurityManager securityManager;
    private final AllowListChecker checker = new AllowListChecker();
    private volatile boolean checkSerializable;

    public FuryCheckerListener(FrameworkModel frameworkModel) {
        this.securityManager = (SerializeSecurityManager)frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        this.securityManager.registerListener((AllowClassNotifyListener)this);
    }

    public void notifyPrefix(Set<String> allowedList, Set<String> disAllowedList) {
        for (String prefix : allowedList) {
            this.checker.allowClass(prefix);
        }
        for (String prefix : disAllowedList) {
            this.checker.disallowClass(prefix);
        }
    }

    public void notifyCheckStatus(SerializeCheckStatus status) {
        switch (status) {
            case DISABLE: {
                this.checker.setCheckLevel(AllowListChecker.CheckLevel.DISABLE);
                return;
            }
            case WARN: {
                this.checker.setCheckLevel(AllowListChecker.CheckLevel.WARN);
                return;
            }
            case STRICT: {
                this.checker.setCheckLevel(AllowListChecker.CheckLevel.STRICT);
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported check level " + status);
    }

    public void notifyCheckSerializable(boolean checkSerializable) {
        this.checkSerializable = checkSerializable;
    }

    public AllowListChecker getChecker() {
        return this.checker;
    }

    public boolean isCheckSerializable() {
        return this.checkSerializable;
    }

    public Serializer createSerializer(Fury fury, Class<?> cls) {
        if (this.checkSerializable && !Serializable.class.isAssignableFrom(cls)) {
            throw new InsecureException(String.format("%s is not Serializable", cls));
        }
        return null;
    }
}

