/*
 * Decompiled with CFR 0.152.
 */
package org.furyio.serialization.dubbo;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;

public class FuryObjectInput
implements ObjectInput {
    private final Fury fury;
    private final MemoryBuffer buffer;
    private final InputStream input;

    public FuryObjectInput(Fury fury, MemoryBuffer buffer, InputStream input) {
        this.fury = fury;
        this.buffer = buffer;
        this.input = input;
    }

    public Object readObject() {
        return this.fury.deserializeJavaObjectAndClass(this.input);
    }

    public <T> T readObject(Class<T> cls) {
        return (T)this.readObject();
    }

    public <T> T readObject(Class<T> cls, Type type) {
        return (T)this.readObject();
    }

    public boolean readBool() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 1);
        return this.buffer.getBoolean(0);
    }

    public byte readByte() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 1);
        return this.buffer.get(0);
    }

    public short readShort() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 2);
        return this.buffer.getShort(0);
    }

    public int readInt() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 4);
        return this.buffer.getInt(0);
    }

    public long readLong() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 8);
        return this.buffer.getLong(0);
    }

    public float readFloat() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 4);
        return this.buffer.getFloat(0);
    }

    public double readDouble() throws IOException {
        this.readBytes(this.buffer.getHeapMemory(), 8);
        return this.buffer.getDouble(0);
    }

    public String readUTF() throws IOException {
        int size = this.readInt();
        this.buffer.readerIndex(0);
        this.buffer.ensure(size);
        this.readBytes(this.buffer.getHeapMemory(), size);
        if (this.buffer.readBoolean()) {
            return this.fury.readJavaString(this.buffer);
        }
        return null;
    }

    public byte[] readBytes() throws IOException {
        int size = this.readInt();
        byte[] bytes = new byte[size];
        this.readBytes(bytes, size);
        return bytes;
    }

    private void readBytes(byte[] bytes, int size) throws IOException {
        for (int off = 0; off != size; off += this.input.read(bytes, off, size - off)) {
        }
    }
}

