/*
 * Decompiled with CFR 0.152.
 */
package org.furyio.serialization.dubbo;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;

public class FuryObjectOutput
implements ObjectOutput {
    private final Fury fury;
    private final MemoryBuffer buffer;
    private final OutputStream output;

    public FuryObjectOutput(Fury fury, MemoryBuffer buffer, OutputStream output) {
        this.fury = fury;
        this.buffer = buffer;
        this.output = output;
    }

    public void writeObject(Object obj) {
        this.fury.serializeJavaObjectAndClass(this.output, obj);
    }

    public void writeBool(boolean v) throws IOException {
        this.buffer.unsafePutBoolean(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 1);
    }

    public void writeByte(byte v) throws IOException {
        this.buffer.unsafePut(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 1);
    }

    public void writeShort(short v) throws IOException {
        this.buffer.unsafePutShort(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 2);
    }

    public void writeInt(int v) throws IOException {
        this.buffer.unsafePutInt(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.buffer.unsafePutLong(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 8);
    }

    public void writeFloat(float v) throws IOException {
        this.buffer.unsafePutFloat(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 4);
    }

    public void writeDouble(double v) throws IOException {
        this.buffer.unsafePutDouble(0, v);
        this.output.write(this.buffer.getHeapMemory(), 0, 8);
    }

    public void writeUTF(String v) throws IOException {
        this.buffer.writerIndex(4);
        if (v != null) {
            this.buffer.writeBoolean(true);
            this.fury.writeJavaString(this.buffer, v);
        } else {
            this.buffer.writeBoolean(false);
        }
        int size = this.buffer.writerIndex() - 4;
        this.writeInt(size);
        this.output.write(this.buffer.getHeapMemory(), 4, size);
    }

    public void writeBytes(byte[] v) throws IOException {
        this.writeInt(v.length);
        this.output.write(v);
    }

    public void writeBytes(byte[] v, int off, int len) throws IOException {
        this.writeInt(len);
        this.output.write(v, off, len);
    }

    public void flushBuffer() throws IOException {
        this.output.flush();
    }
}

