/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetChangeMonitor {
    private DirectoryScanner scanner = new DirectoryScanner();
    private File baseDir;
    private Map<String, File> fileCache = new HashMap<String, File>();
    private Map<String, Long> fileTimestamps = new HashMap<String, Long>();

    public FileSetChangeMonitor(File baseDir, String includePattern) {
        this.baseDir = baseDir;
        this.scanner.setBasedir(baseDir);
        this.scanner.setIncludes(new String[]{includePattern});
        for (String path : this.getPaths()) {
            this.rememberLastModifiedFor(path);
        }
    }

    public List<String> getModifiedFilesSinceLastTimeIAsked() {
        ArrayList<String> modified = new ArrayList<String>();
        for (String path : this.getPaths()) {
            if (this.hasBeenChangedSinceLastTimeIChecked(path)) {
                modified.add(path);
            }
            this.rememberLastModifiedFor(path);
        }
        return modified;
    }

    private boolean hasSeen(String path) {
        return this.fileCache.containsKey(path);
    }

    private boolean hasBeenChangedSinceLastTimeIChecked(String path) {
        return !this.hasSeen(path) || this.fileTimestamps.get(path) < this.getLastModifiedFor(path);
    }

    private void rememberLastModifiedFor(String path) {
        this.fileTimestamps.put(path, this.getLastModifiedFor(path));
    }

    private long getLastModifiedFor(String relativePath) {
        return this.fileFrom(relativePath).lastModified();
    }

    private File fileFrom(String relativePath) {
        if (!this.fileCache.containsKey(relativePath)) {
            this.fileCache.put(relativePath, new File(this.baseDir, relativePath));
        }
        return this.fileCache.get(relativePath);
    }

    private String[] getPaths() {
        this.scanner.scan();
        return this.scanner.getIncludedFiles();
    }
}

