/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import com.voltvoodoo.brew.Closure;
import com.voltvoodoo.brew.DefaultErrorReporter;
import com.voltvoodoo.brew.Module;
import com.voltvoodoo.brew.Optimizer;
import com.voltvoodoo.brew.Uglify;
import com.voltvoodoo.brew.Wrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeMojo
extends AbstractMojo {
    private File optimizeSourceDir;
    private File optimizeBuildDir;
    private File optimizeOutputDir;
    private String optimizedFileNameSuffix;
    private String locale = "en-us";
    private String jsOptimizer = "uglify";
    private String cssOptimizer = "standard";
    private List<String> cssExcludes;
    private String requireUrl = "require.js";
    private boolean inlineText = true;
    private boolean useStrictJs = false;
    private Map<String, Boolean> pragmas;
    private boolean skipPragmas = false;
    private boolean skipModuleInsertion = false;
    private String module = "main";
    private List<Module> modules;
    private Map<String, String> paths = Collections.emptyMap();
    private Map<String, List<String>> packagePaths;
    private List<String> packages;
    private boolean minifyOnlyAggregatedFiles = false;
    private Uglify uglify;
    private Closure closure;
    private Map<String, Boolean> pragmasOnSave;
    private Map<String, Boolean> has;
    private Map<String, Boolean> hasOnSave;
    private String namespace;
    private boolean optimizeAllPluginResources;
    private Wrap wrap;
    private boolean providePlugins = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Optimizer builder = new Optimizer();
            DefaultErrorReporter reporter = new DefaultErrorReporter(this.getLog(), true);
            builder.build(this.optimizeBuildDir, this.providePlugins, this.createBuildProfile(), reporter);
            this.moveModulesToOutputDir();
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException(exc.getMessage(), exc);
        }
    }

    public String getBaseUrl() {
        return this.optimizeSourceDir.getAbsolutePath();
    }

    public File getDir() {
        return this.optimizeBuildDir;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getRequireUrl() {
        return this.requireUrl;
    }

    public String getOptimize() {
        return this.jsOptimizer;
    }

    public String getOptimizeCss() {
        return this.cssOptimizer;
    }

    public boolean isInlineText() {
        return this.inlineText;
    }

    public boolean isUseStrict() {
        return this.useStrictJs;
    }

    public boolean isSkipPragmas() {
        return this.skipPragmas;
    }

    public Map<String, Boolean> getPragmas() {
        return this.pragmas;
    }

    public List<String> getCssImportIgnore() {
        return this.cssExcludes;
    }

    public boolean isSkipModuleInsertion() {
        return this.skipModuleInsertion;
    }

    public List<Module> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<Module>();
            this.modules.add(new Module(this.module));
        }
        return this.modules;
    }

    public Map<String, String> getPaths() {
        return this.paths;
    }

    public Map<String, List<String>> getPackagePaths() {
        return this.packagePaths;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public Uglify getUglify() {
        return this.uglify;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public Map<String, Boolean> getPragmasOnSave() {
        return this.pragmasOnSave;
    }

    public Map<String, Boolean> getHas() {
        return this.has;
    }

    public Map<String, Boolean> getHasOnSave() {
        return this.hasOnSave;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isOptimizeAllPluginResources() {
        return this.optimizeAllPluginResources;
    }

    public Wrap getWrap() {
        return this.wrap;
    }

    @JsonIgnore
    public Log getLog() {
        return super.getLog();
    }

    @JsonIgnore
    public Map getPluginContext() {
        return super.getPluginContext();
    }

    private File createBuildProfile() throws IOException {
        File profileFile = File.createTempFile("profile", "js");
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(profileFile, (Object)this);
        return profileFile;
    }

    private void moveModulesToOutputDir() throws IOException {
        if (!this.optimizeBuildDir.equals(this.optimizeOutputDir) || this.getOptimizedFileNameSuffix().length() > 0) {
            for (Module mod : this.getModules()) {
                File from = new File(this.optimizeBuildDir, mod.getName() + ".js");
                File to = new File(this.optimizeOutputDir, mod.getName() + this.getOptimizedFileNameSuffix() + ".js");
                FileUtils.copyFile((File)from, (File)to);
            }
        }
    }

    private String getOptimizedFileNameSuffix() {
        return this.optimizedFileNameSuffix.equalsIgnoreCase("false") ? "" : this.optimizedFileNameSuffix;
    }

    public boolean isMinifyOnlyAggregatedFiles() {
        return this.minifyOnlyAggregatedFiles;
    }
}

