/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoRunner
extends ScriptableObject {
    private static final long serialVersionUID = 3859222870741981547L;

    public String getClassName() {
        return "global";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(String[] includes, String mainScript, Object[] args, Map<String, Object> globalVariables, ErrorReporter reporter) {
        Context cx = Context.enter();
        cx.setErrorReporter(reporter);
        try {
            Object[] array;
            RhinoRunner runner = new RhinoRunner();
            cx.initStandardObjects((ScriptableObject)runner);
            String[] names = new String[]{"print", "load", "readFile", "warn", "getResourceAsStream"};
            runner.defineFunctionProperties(names, RhinoRunner.class, 2);
            for (String include : includes) {
                runner.processSource(cx, include);
            }
            if (args.length == 0) {
                array = new Object[]{};
            } else {
                int length = args.length;
                array = new Object[length];
                System.arraycopy(args, 0, array, 0, length);
            }
            Scriptable argsObj = cx.newArray((Scriptable)runner, array);
            runner.defineProperty("arguments", argsObj, 2);
            for (String key : globalVariables.keySet()) {
                runner.defineProperty(key, globalVariables.get(key), 2);
            }
            runner.processSource(cx, mainScript);
        }
        finally {
            Context.exit();
        }
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            System.out.print(s);
        }
        System.out.println();
    }

    public static void warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String message = Context.toString((Object)args[0]);
        int line = (int)Context.toNumber((Object)args[1]);
        String source = Context.toString((Object)args[2]);
        int column = (int)Context.toNumber((Object)args[3]);
        cx.getErrorReporter().warning(message, null, line, source, column);
    }

    public String readFile(String path) {
        try {
            File file = new File(path);
            InputStream inputStream = file.exists() ? new FileInputStream(path) : ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            return IOUtil.toString((InputStream)inputStream);
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException("wrap: " + exc.getMessage(), exc);
        }
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        RhinoRunner runner = (RhinoRunner)RhinoRunner.getTopLevelScope((Scriptable)thisObj);
        for (Object element : args) {
            runner.processSource(cx, Context.toString((Object)element));
        }
    }

    public InputStream getResourceAsStream(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                return new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSource(Context cx, String filename) {
        if (filename != null) {
            InputStreamReader in = null;
            try {
                in = new FileReader(filename);
            }
            catch (FileNotFoundException ex) {
                try {
                    if (filename.startsWith(".")) {
                        filename = filename.substring(1);
                    }
                    if (!filename.startsWith("/")) {
                        filename = "/" + filename;
                    }
                    in = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename));
                }
                catch (Exception e) {
                    Context.reportError((String)("Couldn't open file \"" + filename + "\"."));
                    return;
                }
            }
            try {
                cx.evaluateReader((Scriptable)this, (Reader)in, filename, 1, null);
            }
            catch (WrappedException we) {
                System.err.println(we.getWrappedException().toString());
                we.printStackTrace();
            }
            catch (EvaluatorException ee) {
                System.err.println("js: " + ee.getMessage());
            }
            catch (JavaScriptException jse) {
                System.err.println("js: " + jse.getMessage());
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    System.err.println(ioe.toString());
                }
            }
        }
    }
}

