/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.voltvoodoo.brew.compile.CoffeeScriptCompileException;
import com.voltvoodoo.brew.compile.Compiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextFileCompiler
implements Compiler {
    private String outputFileSuffix;

    public AbstractTextFileCompiler(String outputFileSuffix) {
        this.outputFileSuffix = outputFileSuffix;
    }

    public abstract String compile(String var1);

    public void compile(File source, File target) throws CoffeeScriptCompileException, IOException {
        if (target.exists()) {
            target.delete();
        }
        target.getParentFile().mkdirs();
        target.createNewFile();
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        String compiled = this.compile(IOUtil.toString((InputStream)in));
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    @Override
    public void compile(List<String> files, File sourceDir, File targetDir) {
        try {
            for (String path : files) {
                String newPath = path.substring(0, path.lastIndexOf(46)) + this.outputFileSuffix;
                this.compile(new File(sourceDir, path), new File(targetDir, newPath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

