/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.voltvoodoo.brew.compile.CoffeeScriptCompileException;
import com.voltvoodoo.brew.compile.CoffeeScriptCompiler;
import com.voltvoodoo.brew.compile.Compiler;
import com.voltvoodoo.brew.compile.CompilerMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeJadeCompiler
implements Compiler {
    private final CompilerMojo mojo;
    private final Scriptable globalScope;
    private final String options;
    private File singleViewFile;
    private Map<String, String> viewCache = new HashMap<String, String>();
    private CoffeeScriptCompiler coffeeCompiler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoffeeJadeCompiler(CompilerMojo mojo, String options) {
        this.mojo = mojo;
        this.singleViewFile = mojo.getViewsMapOutputFile();
        this.coffeeCompiler = mojo.getCoffeeCompiler();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/fusesource/coffeejade/coffeejade.js");
        try {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    Context context = Context.enter();
                    context.setOptimizationLevel(-1);
                    try {
                        this.globalScope = context.initStandardObjects();
                        context.evaluateString(this.globalScope, "var window = {};", "JCoffeeJadeCompiler", 0, null);
                        context.evaluateReader(this.globalScope, (Reader)reader, "coffeejade.js", 0, null);
                    }
                    finally {
                        Context.exit();
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.options = options;
    }

    public void writeSingleViewFile() {
        if (this.isSingleViewFileEnabled()) {
            this.singleViewFile.getParentFile().mkdirs();
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(this.singleViewFile));
                out.println("define(['frameworks'], function() {");
                out.println("  var templates;");
                out.println("  templates = {};");
                for (Map.Entry<String, String> entry : this.viewCache.entrySet()) {
                    String jadeSource = entry.getKey();
                    String js = entry.getValue();
                    int idx = js.indexOf(10);
                    if (idx > 0) {
                        js = js.substring(idx + 1);
                    }
                    for (int i = 0; i < 2; ++i) {
                        idx = js.lastIndexOf(10);
                        if (idx <= 0) continue;
                        js = js.substring(0, idx);
                    }
                    out.println("  templates['" + jadeSource + "'] = " + js);
                }
                out.println("  return templates;");
                out.println("});");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public String compile(String jadeSource, String relativePath) {
        Context context = Context.enter();
        try {
            Scriptable compileScope = context.newObject(this.globalScope);
            compileScope.setParentScope(this.globalScope);
            compileScope.put("jadeSource", compileScope, (Object)jadeSource);
            try {
                String source = String.format("window.jade.compile(jadeSource, %s).code;", this.options);
                String coffee = (String)context.evaluateString(compileScope, source, "JCoffeeJadeCompiler", 0, null);
                String js = this.coffeeCompiler.compile(coffee);
                this.cacheResult(relativePath, js);
                String string = js;
                return string;
            }
            catch (JavaScriptException e) {
                throw new CoffeeScriptCompileException(e);
            }
        }
        finally {
            Context.exit();
        }
    }

    private void cacheResult(String source, String js) {
        if (this.isSingleViewFileEnabled()) {
            this.viewCache.put(source, js);
        }
    }

    protected boolean isSingleViewFileEnabled() {
        return this.singleViewFile != null;
    }

    public void compile(File source, File target) throws CoffeeScriptCompileException, IOException {
        if (target.exists()) {
            target.delete();
        }
        target.getParentFile().mkdirs();
        target.createNewFile();
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        String compiled = this.compile(IOUtil.toString((InputStream)in), source.toString());
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    @Override
    public void compile(List<String> files, File sourceDir, File targetDir) {
        try {
            for (String path : files) {
                String newPath = path.substring(0, path.lastIndexOf(46)) + ".js";
                this.compile(new File(sourceDir, path), new File(targetDir, newPath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

