/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.voltvoodoo.brew.DefaultErrorReporter;
import com.voltvoodoo.brew.FileSetChangeMonitor;
import com.voltvoodoo.brew.Optimizer;
import com.voltvoodoo.brew.compile.CoffeeJadeCompiler;
import com.voltvoodoo.brew.compile.CoffeeScriptCompileException;
import com.voltvoodoo.brew.compile.CoffeeScriptCompiler;
import com.voltvoodoo.brew.compile.CoffeeScriptOption;
import com.voltvoodoo.brew.compile.HamlCompiler;
import com.voltvoodoo.brew.compile.RawCopyCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.JavaScriptException;

public class CompilerMojo
extends AbstractMojo {
    private static final String COFFEE_PATTERN = "**/*.coffee";
    private static final String HAML_PATTERN = "**/*.haml";
    private static final String JADE_PATTERN = "**/*.jade";
    private static final String ANY_PATTERN = "**/*";
    private File hamlSourceDir;
    private File hamlOutputDir;
    private File jadeSourceDir;
    private File jadeOutputDir;
    private File viewsMapOutputFile;
    private String coffeeJadeOptions;
    private File moduleConversionSourceDir;
    private File moduleConversionOutputDir;
    private File coffeeSourceDir;
    private File coffeeOutputDir;
    private File resourceSourceDir;
    private File resourceOutputDir;
    private boolean watch = false;
    private String amdModuleSuffix;
    private HamlCompiler hamlCompiler;
    private Optimizer moduleConverter;
    private CoffeeScriptCompiler coffeeCompiler;
    private CoffeeJadeCompiler jadeCompiler;
    private RawCopyCompiler resourceCompiler;
    private Set<String> sourceFilePaths = new HashSet<String>();

    public void execute() throws MojoExecutionException {
        try {
            this.hamlCompiler = new HamlCompiler();
            this.moduleConverter = new Optimizer();
            this.resourceCompiler = new RawCopyCompiler(this);
            for (String relativePath : this.getCoffeeScriptsRelativePaths()) {
                try {
                    this.compileCoffeescriptFile(relativePath);
                }
                catch (CoffeeScriptCompileException e) {
                    this.getLog().error((CharSequence)("[" + relativePath + "]: " + e.getMessage()));
                    throw e;
                }
            }
            for (String relativePath : this.getHamlRelativePaths()) {
                try {
                    this.compileHamlFile(relativePath);
                }
                catch (JavaScriptException e) {
                    this.getLog().error((CharSequence)("[" + relativePath + "]: " + e.getMessage()));
                    throw e;
                }
            }
            for (String relativePath : this.getJadeRelativePaths()) {
                try {
                    this.compileJadeFile(relativePath);
                }
                catch (JavaScriptException e) {
                    this.getLog().error((CharSequence)("[" + relativePath + "]: " + e.getMessage()));
                    throw e;
                }
            }
            this.writeSingleViewFile();
            String[] resourcePaths = this.getResourceRelativePaths();
            if (resourcePaths != null && resourcePaths.length > 0) {
                try {
                    List<String> files = Arrays.asList(resourcePaths);
                    this.resourceCompiler.compile(files, this.resourceSourceDir, this.resourceOutputDir);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            if (this.watch) {
                System.out.println("Watching for changes to coffeescript and haml files..");
                this.checkForChangesEvery(500L);
            }
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException(exc.getMessage(), exc);
        }
    }

    public CoffeeScriptCompiler getCoffeeCompiler() {
        if (this.coffeeCompiler == null) {
            this.coffeeCompiler = new CoffeeScriptCompiler(new LinkedList<CoffeeScriptOption>());
        }
        return this.coffeeCompiler;
    }

    protected void writeSingleViewFile() {
        if (this.jadeCompiler != null) {
            this.jadeCompiler.writeSingleViewFile();
        }
    }

    public File getViewsMapOutputFile() {
        return this.viewsMapOutputFile;
    }

    private void checkForChangesEvery(long ms) throws FileNotFoundException, CoffeeScriptCompileException, IOException {
        FileSetChangeMonitor hamlFiles = new FileSetChangeMonitor(this.hamlSourceDir, HAML_PATTERN);
        FileSetChangeMonitor jadeFiles = new FileSetChangeMonitor(this.jadeSourceDir, JADE_PATTERN);
        FileSetChangeMonitor coffeeFiles = new FileSetChangeMonitor(this.coffeeSourceDir, COFFEE_PATTERN);
        FileSetChangeMonitor resourceFiles = new FileSetChangeMonitor(this.resourceSourceDir, ANY_PATTERN);
        try {
            block10: while (true) {
                Thread.sleep(ms);
                for (String file : hamlFiles.getModifiedFilesSinceLastTimeIAsked()) {
                    try {
                        this.compileHamlFile(file);
                        System.out.println("[" + file + "]: Compiled");
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("[" + file + "]: " + e.getMessage()));
                    }
                }
                boolean jadeChanged = false;
                for (String file : jadeFiles.getModifiedFilesSinceLastTimeIAsked()) {
                    try {
                        this.compileJadeFile(file);
                        jadeChanged = true;
                        System.out.println("[" + file + "]: Compiled");
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("[" + file + "]: " + e.getMessage()));
                    }
                }
                if (jadeChanged) {
                    this.writeSingleViewFile();
                }
                for (String file : coffeeFiles.getModifiedFilesSinceLastTimeIAsked()) {
                    try {
                        this.compileCoffeescriptFile(file);
                        System.out.println("[" + file + "]: Compiled");
                    }
                    catch (Exception e) {
                        this.getLog().error((CharSequence)("[" + file + "]: " + e.getMessage()));
                    }
                }
                Iterator<String> i$ = resourceFiles.getModifiedFilesSinceLastTimeIAsked().iterator();
                while (true) {
                    String file;
                    if (!i$.hasNext()) continue block10;
                    file = i$.next();
                    try {
                        this.resourceCompiler.copyFile(file, this.resourceSourceDir, this.resourceOutputDir);
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("[" + file + "]: " + e.getMessage()));
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.getLog().info((CharSequence)"Caught interrupt, quitting.");
            return;
        }
    }

    private void compileCoffeescriptFile(String relativePath) throws FileNotFoundException, CoffeeScriptCompileException, IOException {
        File coffee = new File(this.coffeeSourceDir, relativePath);
        this.addSourcefile(coffee);
        File js = new File(this.coffeeOutputDir, relativePath.substring(0, relativePath.lastIndexOf(46)) + ".js");
        this.getCoffeeCompiler().compile(coffee, js);
    }

    private void convertFromCommonModuleToAMD(String relativePath) throws IOException {
        String relativeAmdPath = relativePath.substring(0, relativePath.lastIndexOf(46)) + this.amdModuleSuffix + ".js";
        File commonFile = new File(this.moduleConversionSourceDir, relativePath).getAbsoluteFile();
        File amdFile = new File(this.moduleConversionOutputDir, relativeAmdPath).getAbsoluteFile();
        this.moduleConverter.convertCommonJsModulesToAmdModules(commonFile, amdFile, new DefaultErrorReporter(this.getLog(), true));
    }

    private void compileHamlFile(String relativePath) throws IOException {
        File coffee = new File(this.hamlSourceDir, relativePath).getAbsoluteFile();
        this.addSourcefile(coffee);
        File js = new File(this.hamlOutputDir, relativePath.substring(0, relativePath.lastIndexOf(46)) + ".js").getAbsoluteFile();
        if (js.exists()) {
            js.delete();
        }
        js.getParentFile().mkdirs();
        js.createNewFile();
        FileInputStream in = new FileInputStream(coffee);
        FileOutputStream out = new FileOutputStream(js);
        String compiled = this.hamlCompiler.compile(IOUtil.toString((InputStream)in));
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    private void compileJadeFile(String relativePath) throws IOException {
        if (this.jadeCompiler == null) {
            this.jadeCompiler = new CoffeeJadeCompiler(this, this.coffeeJadeOptions);
        }
        File jade = new File(this.jadeSourceDir, relativePath).getAbsoluteFile();
        this.addSourcefile(jade);
        File js = new File(this.jadeOutputDir, relativePath.substring(0, relativePath.lastIndexOf(46)) + ".js").getAbsoluteFile();
        if (js.exists()) {
            js.delete();
        }
        js.getParentFile().mkdirs();
        js.createNewFile();
        FileInputStream in = new FileInputStream(jade);
        FileOutputStream out = new FileOutputStream(js);
        String compiled = this.jadeCompiler.compile(IOUtil.toString((InputStream)in), relativePath);
        IOUtil.copy((String)compiled, (OutputStream)out);
        in.close();
        out.close();
    }

    private String toFileKey(File source) {
        return source.getAbsolutePath();
    }

    public void addSourcefile(File source) {
        this.sourceFilePaths.add(this.toFileKey(source));
    }

    public boolean isSourceFile(File source) {
        return this.sourceFilePaths.contains(this.toFileKey(source));
    }

    private String[] getHamlRelativePaths() throws MojoFailureException {
        return this.getRelativePaths(this.hamlSourceDir, HAML_PATTERN);
    }

    private String[] getJadeRelativePaths() throws MojoFailureException {
        return this.getRelativePaths(this.jadeSourceDir, JADE_PATTERN);
    }

    private String[] getCoffeeScriptsRelativePaths() throws MojoFailureException {
        return this.getRelativePaths(this.coffeeSourceDir, COFFEE_PATTERN);
    }

    private String[] getResourceRelativePaths() throws MojoFailureException {
        return this.getRelativePaths(this.resourceSourceDir, ANY_PATTERN);
    }

    private String[] getRelativePaths(File baseDir, String pattern) throws MojoFailureException {
        if (baseDir == null || !baseDir.exists()) {
            return new String[0];
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        scanner.setIncludes(new String[]{pattern});
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

