/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.voltvoodoo.brew.JSRunner;
import com.voltvoodoo.brew.compile.AbstractTextFileCompiler;
import java.util.HashMap;

public class HamlCompiler
extends AbstractTextFileCompiler {
    private static final String hamlClasspathFilename = "/haml/haml.js";
    private static final String jsonClasspathFilename = "/haml/json2.js";
    private JSRunner js = new JSRunner();

    public HamlCompiler() {
        super("js");
        this.js.evalScript(jsonClasspathFilename);
        this.js.evalScript(hamlClasspathFilename);
    }

    public String compile(String haml) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("hamlSource", haml);
        return this.addModuleDefinition(this.js.evalString("Haml.optimize(Haml.compile(hamlSource));", "HamlCompiler", vars));
    }

    private String addModuleDefinition(String script) {
        return "(function(define){\ndefine(function(){return function(vars){\nwith(vars||{}) {\nreturn " + script + "; \n" + "}};\n" + "})" + ";})(typeof define==\"function\"?\n" + "define:\n" + "function(factory){module.exports=factory.apply(this, deps.map(require));});\n";
    }
}

