/*
 * Decompiled with CFR 0.152.
 */
package com.voltvoodoo.brew.compile;

import com.voltvoodoo.brew.compile.Compiler;
import com.voltvoodoo.brew.compile.CompilerMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawCopyCompiler
implements Compiler {
    private final CompilerMojo mojo;

    public RawCopyCompiler(CompilerMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void compile(List<String> files, File sourceDir, File targetDir) {
        for (String path : files) {
            try {
                this.copyFile(path, sourceDir, targetDir);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String path, File sourceDir, File targetDir) throws IOException {
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            File source = new File(sourceDir, path);
            if (source.exists() && !this.mojo.isSourceFile(source)) {
                File target = new File(targetDir, path);
                File parentDir = target.getParentFile();
                parentDir.mkdirs();
                if (parentDir.exists()) {
                    in = new FileInputStream(source);
                    out = new FileOutputStream(target);
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                }
            }
        }
        finally {
            IOUtil.close(in);
            IOUtil.close(out);
        }
    }
}

