/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf.proto.compiler;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.fusesource.hawtbuf.proto.compiler.AltJavaGenerator;
import org.fusesource.hawtbuf.proto.compiler.CompilerException;
import org.fusesource.hawtbuf.proto.compiler.JavaGenerator;

public class ProtoMojo
extends AbstractMojo {
    protected MavenProject project;
    private File mainSourceDirectory;
    private File mainOutputDirectory;
    private File testSourceDirectory;
    private File testOutputDirectory;
    private String type;

    public void execute() throws MojoExecutionException {
        File[] mainFiles = null;
        if (this.mainSourceDirectory.exists()) {
            mainFiles = this.mainSourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".proto");
                }
            });
            if (mainFiles == null || mainFiles.length == 0) {
                this.getLog().warn((CharSequence)("No proto files found in directory: " + this.mainSourceDirectory.getPath()));
            } else {
                this.processFiles(mainFiles, this.mainOutputDirectory);
                this.project.addCompileSourceRoot(this.mainOutputDirectory.getAbsolutePath());
            }
        }
        File[] testFiles = null;
        if (this.testSourceDirectory.exists()) {
            testFiles = this.testSourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".proto");
                }
            });
            if (testFiles == null || testFiles.length == 0) {
                this.getLog().warn((CharSequence)("No proto files found in directory: " + this.testSourceDirectory.getPath()));
            } else {
                this.processFiles(testFiles, this.testOutputDirectory);
                this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
            }
        }
    }

    private void processFiles(File[] mainFiles, File outputDir) throws MojoExecutionException {
        List<File> recFiles = Arrays.asList(mainFiles);
        for (File file : recFiles) {
            try {
                Object generator;
                this.getLog().info((CharSequence)("Compiling: " + file.getPath()));
                if ("default".equals(this.type)) {
                    generator = new JavaGenerator();
                    ((JavaGenerator)generator).setOut(outputDir);
                    ((JavaGenerator)generator).compile(file);
                    continue;
                }
                if (!"alt".equals(this.type)) continue;
                generator = new AltJavaGenerator();
                ((AltJavaGenerator)generator).setOut(outputDir);
                ((AltJavaGenerator)generator).compile(file);
            }
            catch (CompilerException e) {
                this.getLog().error((CharSequence)"Protocol Buffer Compiler failed with the following error(s):");
                for (String error : e.getErrors()) {
                    this.getLog().error((CharSequence)"");
                    this.getLog().error((CharSequence)error);
                }
                this.getLog().error((CharSequence)"");
                throw new MojoExecutionException("Compile failed.  For more details see error messages listed above.", (Exception)e);
            }
        }
    }
}

