/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.fusesource.hawtdispatch.transport.TcpTransport;

public class SslTransport
extends TcpTransport {
    private SSLContext sslContext;
    private SSLEngine engine;
    private ByteBuffer readBuffer;
    private boolean readUnderflow;
    private ByteBuffer writeBuffer;
    private boolean writeFlushing;
    private ByteBuffer readOverflowBuffer;
    private SSLChannel ssl_channel = new SSLChannel();
    private Executor blockingExecutor;

    public static String protocol(String scheme) {
        if (scheme.equals("tls")) {
            return "TLS";
        }
        if (scheme.startsWith("tlsv")) {
            return "TLSv" + scheme.substring(4);
        }
        if (scheme.equals("ssl")) {
            return "SSL";
        }
        if (scheme.startsWith("sslv")) {
            return "SSLv" + scheme.substring(4);
        }
        return null;
    }

    public void setSSLContext(SSLContext ctx) {
        this.sslContext = ctx;
    }

    public static SslTransport createTransport(URI uri) throws Exception {
        String protocol = SslTransport.protocol(uri.getScheme());
        if (protocol != null) {
            SslTransport rc = new SslTransport();
            rc.setSSLContext(SSLContext.getInstance(protocol));
            return rc;
        }
        return null;
    }

    public SSLSession getSSLSession() {
        return this.engine == null ? null : this.engine.getSession();
    }

    public X509Certificate[] getPeerX509Certificates() {
        if (this.engine == null) {
            return null;
        }
        try {
            ArrayList<X509Certificate> rc = new ArrayList<X509Certificate>();
            for (Certificate c : this.engine.getSession().getPeerCertificates()) {
                if (!(c instanceof X509Certificate)) continue;
                rc.add((X509Certificate)c);
            }
            return rc.toArray(new X509Certificate[rc.size()]);
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public void connecting(URI remoteLocation, URI localLocation) throws Exception {
        assert (this.engine == null);
        this.engine = this.sslContext.createSSLEngine();
        this.engine.setUseClientMode(true);
        super.connecting(remoteLocation, localLocation);
    }

    public void connected(SocketChannel channel) throws Exception {
        if (this.engine == null) {
            this.engine = this.sslContext.createSSLEngine();
            this.engine.setUseClientMode(false);
            this.engine.setWantClientAuth(true);
        }
        SSLSession session = this.engine.getSession();
        this.readBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        super.connected(channel);
    }

    protected void onConnected() throws IOException {
        super.onConnected();
        this.engine.setWantClientAuth(true);
        this.engine.beginHandshake();
        this.handshake();
    }

    public void flush() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        } else {
            super.flush();
        }
    }

    protected void drainInbound() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        } else {
            super.drainInbound();
        }
    }

    protected boolean transportFlush() throws IOException {
        while (true) {
            if (this.writeFlushing) {
                int count = super.writeChannel().write(this.writeBuffer);
                if (!this.writeBuffer.hasRemaining()) {
                    this.writeBuffer.clear();
                    this.writeFlushing = false;
                    this.suspendWrite();
                    return true;
                }
                return false;
            }
            if (this.writeBuffer.position() == 0) break;
            this.writeBuffer.flip();
            this.writeFlushing = true;
            this.resumeWrite();
        }
        return true;
    }

    private int secure_write(ByteBuffer plain) throws IOException {
        if (!this.transportFlush()) {
            return 0;
        }
        int rc = 0;
        while (plain.hasRemaining() || this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult result = this.engine.wrap(plain, this.writeBuffer);
            assert (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW);
            rc += result.bytesConsumed();
            if (this.transportFlush()) continue;
            break;
        }
        if (plain.remaining() == 0 && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.dispatchQueue.execute(new Runnable(){

                public void run() {
                    SslTransport.this.handshake();
                }
            });
        }
        return rc;
    }

    private int secure_read(ByteBuffer plain) throws IOException {
        int rc = 0;
        while (plain.hasRemaining() || this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.readOverflowBuffer != null) {
                if (plain.hasRemaining()) {
                    int size = Math.min(plain.remaining(), this.readOverflowBuffer.remaining());
                    plain.put(this.readOverflowBuffer.array(), this.readOverflowBuffer.position(), size);
                    this.readOverflowBuffer.position(this.readOverflowBuffer.position() + size);
                    if (!this.readOverflowBuffer.hasRemaining()) {
                        this.readOverflowBuffer = null;
                    }
                    rc += size;
                    continue;
                }
                return rc;
            }
            if (this.readUnderflow) {
                int count = super.readChannel().read(this.readBuffer);
                if (count == -1) {
                    if (rc == 0) {
                        return -1;
                    }
                    return rc;
                }
                if (count == 0) {
                    return rc;
                }
                this.readUnderflow = false;
                this.readBuffer.flip();
                continue;
            }
            SSLEngineResult result = this.engine.unwrap(this.readBuffer, plain);
            rc += result.bytesProduced();
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.readOverflowBuffer = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
                result = this.engine.unwrap(this.readBuffer, this.readOverflowBuffer);
                if (this.readOverflowBuffer.position() == 0) {
                    this.readOverflowBuffer = null;
                } else {
                    this.readOverflowBuffer.flip();
                }
            }
            switch (result.getStatus()) {
                case CLOSED: {
                    if (rc == 0) {
                        this.engine.closeInbound();
                        return -1;
                    }
                    return rc;
                }
                case OK: {
                    if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                    this.dispatchQueue.execute(new Runnable(){

                        public void run() {
                            SslTransport.this.handshake();
                        }
                    });
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    this.readBuffer.compact();
                    this.readUnderflow = true;
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new AssertionError((Object)"Unexpected case.");
                }
            }
        }
        return rc;
    }

    public void handshake() {
        try {
            if (!this.transportFlush()) {
                return;
            }
            switch (this.engine.getHandshakeStatus()) {
                case NEED_TASK: {
                    final Runnable task = this.engine.getDelegatedTask();
                    if (task != null) {
                        this.blockingExecutor.execute(new Runnable(){

                            public void run() {
                                task.run();
                                SslTransport.this.dispatchQueue.execute(new Runnable(){

                                    public void run() {
                                        if (SslTransport.this.isConnected()) {
                                            SslTransport.this.handshake();
                                        }
                                    }
                                });
                            }
                        });
                    }
                    break;
                }
                case NEED_WRAP: {
                    this.secure_write(ByteBuffer.allocate(0));
                    break;
                }
                case NEED_UNWRAP: {
                    this.secure_read(ByteBuffer.allocate(0));
                    break;
                }
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    break;
                }
                default: {
                    System.err.println("Unexpected ssl engine handshake status: " + (Object)((Object)this.engine.getHandshakeStatus()));
                    break;
                }
            }
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    public ReadableByteChannel readChannel() {
        return this.ssl_channel;
    }

    public WritableByteChannel writeChannel() {
        return this.ssl_channel;
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    public class SSLChannel
    implements ScatteringByteChannel,
    GatheringByteChannel {
        public int write(ByteBuffer plain) throws IOException {
            return SslTransport.this.secure_write(plain);
        }

        public int read(ByteBuffer plain) throws IOException {
            return SslTransport.this.secure_read(plain);
        }

        public boolean isOpen() {
            return SslTransport.this.getSocketChannel().isOpen();
        }

        public void close() throws IOException {
            SslTransport.this.getSocketChannel().close();
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (offset + length > srcs.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[offset + i];
                if (src.hasRemaining()) {
                    rc += (long)this.write(src);
                }
                if (!src.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (offset + length > dsts.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer dst = dsts[offset + i];
                if (dst.hasRemaining()) {
                    rc += (long)this.read(dst);
                }
                if (!dst.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        public Socket socket() {
            SocketChannel c = SslTransport.this.channel;
            if (c == null) {
                return null;
            }
            return c.socket();
        }
    }
}

