/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIMethod;
import org.fusesource.hawtjni.generator.model.JNIParameter;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.generator.model.ReflectClass;
import org.fusesource.hawtjni.generator.model.ReflectParameter;
import org.fusesource.hawtjni.generator.model.ReflectType;
import org.fusesource.hawtjni.generator.util.TextSupport;
import org.fusesource.hawtjni.runtime.ArgFlag;
import org.fusesource.hawtjni.runtime.JniArg;
import org.fusesource.hawtjni.runtime.JniMethod;
import org.fusesource.hawtjni.runtime.MethodFlag;
import org.fusesource.hawtjni.runtime.T32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectMethod
implements JNIMethod {
    private ReflectClass declaringClass;
    private Method method;
    private List<JNIType> paramTypes32;
    private List<JNIType> paramTypes64;
    private List<JNIParameter> parameters;
    private boolean unique;
    private JniMethod annotation;
    private boolean allowConversion;
    private ReflectType returnType;
    private HashSet<MethodFlag> flags;

    public ReflectMethod(ReflectClass declaringClass, Method method) {
        this.declaringClass = declaringClass;
        this.method = method;
        this.lazyLoad();
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectMethod)) {
            return false;
        }
        return ((ReflectMethod)obj).method.equals(this.method);
    }

    public String toString() {
        return this.method.toString();
    }

    public Method getWrapedMethod() {
        return this.method;
    }

    @Override
    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public List<JNIParameter> getParameters() {
        this.lazyLoad();
        return this.parameters;
    }

    @Override
    public List<JNIType> getParameterTypes() {
        this.lazyLoad();
        return this.paramTypes32;
    }

    @Override
    public List<JNIType> getParameterTypes64() {
        this.lazyLoad();
        return this.paramTypes64;
    }

    @Override
    public JNIType getReturnType32() {
        this.lazyLoad();
        return this.returnType.asType32(this.allowConversion);
    }

    @Override
    public JNIType getReturnType64() {
        this.lazyLoad();
        return this.returnType.asType64(this.allowConversion);
    }

    @Override
    public boolean getFlag(MethodFlag flag) {
        this.lazyLoad();
        return this.flags.contains((Object)flag);
    }

    @Override
    public String getCast() {
        this.lazyLoad();
        String rc = this.annotation == null ? "" : this.annotation.cast();
        return TextSupport.cast(rc);
    }

    @Override
    public boolean isPointer() {
        this.lazyLoad();
        if (this.annotation == null) {
            return false;
        }
        return this.getFlag(MethodFlag.POINTER_RETURN) || this.returnType.getWrappedClass() == Long.TYPE && this.getCast().endsWith("*)");
    }

    @Override
    public String getCopy() {
        this.lazyLoad();
        return this.annotation == null ? "" : this.annotation.copy();
    }

    @Override
    public String getAccessor() {
        this.lazyLoad();
        return this.annotation == null ? "" : this.annotation.accessor();
    }

    @Override
    public String getConditional() {
        String myConditional;
        this.lazyLoad();
        String parentConditional = this.getDeclaringClass().getConditional();
        String string = myConditional = this.annotation == null ? null : ReflectMethod.emptyFilter(this.annotation.conditional());
        if (parentConditional != null) {
            if (myConditional != null) {
                return parentConditional + " && " + myConditional;
            }
            return parentConditional;
        }
        return myConditional;
    }

    @Override
    public boolean isNativeUnique() {
        this.lazyLoad();
        return this.unique;
    }

    @Override
    public String[] getCallbackTypes() {
        this.lazyLoad();
        if (this.annotation == null) {
            return new String[0];
        }
        JniArg[] callbackArgs = this.annotation.callbackArgs();
        String[] rc = new String[callbackArgs.length];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = callbackArgs[i].cast();
        }
        return rc;
    }

    @Override
    public ArgFlag[][] getCallbackFlags() {
        this.lazyLoad();
        if (this.annotation == null) {
            return new ArgFlag[0][];
        }
        JniArg[] callbackArgs = this.annotation.callbackArgs();
        ArgFlag[][] rc = new ArgFlag[callbackArgs.length][];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = callbackArgs[i].flags();
        }
        return rc;
    }

    public static String emptyFilter(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private void lazyLoad() {
        if (this.flags != null) {
            return;
        }
        this.annotation = this.method.getAnnotation(JniMethod.class);
        this.allowConversion = this.method.getAnnotation(T32.class) != null;
        this.flags = new HashSet();
        if (this.annotation != null) {
            this.flags.addAll(Arrays.asList(this.annotation.flags()));
        }
        Class<?> returnType = this.method.getReturnType();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        this.paramTypes32 = new ArrayList<JNIType>(paramTypes.length);
        this.paramTypes64 = new ArrayList<JNIType>(paramTypes.length);
        this.parameters = new ArrayList<JNIParameter>(paramTypes.length);
        this.returnType = new ReflectType(returnType);
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            ReflectParameter parameter = new ReflectParameter(this, i, parameterAnnotations[i]);
            this.parameters.add(parameter);
            this.paramTypes32.add(parameter.getType32());
            this.paramTypes64.add(parameter.getType64());
        }
        this.unique = true;
        Class<?> parent = this.declaringClass.getWrapedClass();
        String name = this.method.getName();
        for (Method mth : parent.getDeclaredMethods()) {
            if ((mth.getModifiers() & 0x100) == 0 || this.method == mth || this.method.equals(mth) || !name.equals(mth.getName())) continue;
            this.unique = false;
            break;
        }
    }
}

