/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    static String ENCONDING = "UTF8";
    PrintStream out;
    String[] attributeFilter;
    String nodeFilter;

    public DOMWriter(PrintStream out) {
        this.out = new PrintStream(out);
    }

    String nodeName(Node node) {
        return node.getNodeName();
    }

    boolean filter(Attr attr) {
        if (this.attributeFilter == null) {
            return false;
        }
        String name = attr.getNodeName();
        for (int i = 0; i < this.attributeFilter.length; ++i) {
            if (!name.matches(this.attributeFilter[i])) continue;
            return false;
        }
        return true;
    }

    void print(String str) {
        this.out.print(str);
    }

    void println() {
        this.out.println();
    }

    public void print(Node node) {
        this.print(node, 0);
    }

    public void print(Node node, int level) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.print("<?xml version=\"1.0\" encoding=\"");
                this.print(ENCONDING);
                this.print("\"?>");
                this.println();
                this.print(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                Attr attr;
                int i;
                Attr[] attrs = this.sort(node.getAttributes());
                String name = this.nodeName(node);
                boolean gen = name.equals("arg") || name.equals("retval");
                for (i = 0; i < attrs.length && !gen; ++i) {
                    attr = attrs[i];
                    if (!this.nodeName(attr).startsWith(this.nodeFilter)) continue;
                    gen = true;
                }
                if (!gen) break;
                for (i = 0; i < level; ++i) {
                    this.print("\t");
                }
                this.print("<");
                this.print(name);
                for (i = 0; i < attrs.length; ++i) {
                    attr = attrs[i];
                    if (this.filter(attr)) continue;
                    this.print(" ");
                    this.print(this.nodeName(attr));
                    this.print("=\"");
                    this.print(this.normalize(attr.getNodeValue()));
                    this.print("\"");
                }
                this.print(">");
                NodeList children = node.getChildNodes();
                int count = 0;
                if (children != null) {
                    int i2;
                    int len = children.getLength();
                    for (i2 = 0; i2 < len; ++i2) {
                        if (children.item(i2).getNodeType() != 1) continue;
                        ++count;
                    }
                    if (count > 0) {
                        this.println();
                    }
                    for (i2 = 0; i2 < len; ++i2) {
                        this.print(children.item(i2), level + 1);
                    }
                    if (count > 0) {
                        for (i2 = 0; i2 < level; ++i2) {
                            this.print("\t");
                        }
                    }
                }
                this.print("</");
                this.print(this.nodeName(node));
                this.print(">");
                this.println();
                break;
            }
        }
        this.out.flush();
    }

    Attr[] sort(NamedNodeMap attrs) {
        if (attrs == null) {
            return new Attr[0];
        }
        Attr[] result = new Attr[attrs.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Attr)attrs.item(i);
        }
        Arrays.sort(result, new Comparator<Node>(){

            @Override
            public int compare(Node arg0, Node arg1) {
                return DOMWriter.this.nodeName(arg0).compareTo(DOMWriter.this.nodeName(arg1));
            }
        });
        return result;
    }

    String normalize(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    str.append("\"");
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public void setNodeFilter(String filter) {
        this.nodeFilter = filter;
    }

    public void setAttributeFilter(String[] filter) {
        this.attributeFilter = filter;
    }
}

