/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator.model;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIMethod;
import org.fusesource.hawtjni.generator.model.JNIParameter;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.generator.model.ReflectClass;
import org.fusesource.hawtjni.generator.model.ReflectMethod;
import org.fusesource.hawtjni.generator.model.ReflectType;
import org.fusesource.hawtjni.generator.util.TextSupport;
import org.fusesource.hawtjni.runtime.ArgFlag;
import org.fusesource.hawtjni.runtime.JniArg;
import org.fusesource.hawtjni.runtime.T32;

public class ReflectParameter
implements JNIParameter {
    private ReflectMethod method;
    private ReflectType type;
    private int parameter;
    private JniArg annotation;
    private boolean allowConversion;
    private HashSet<ArgFlag> flags;

    public ReflectParameter(ReflectMethod method, int parameter, Annotation[] annotations) {
        this.method = method;
        this.parameter = parameter;
        this.type = new ReflectType(method.getWrapedMethod().getParameterTypes()[parameter]);
        this.flags = new HashSet();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof JniArg) {
                    this.annotation = (JniArg)annotation;
                    this.flags.addAll(Arrays.asList(this.annotation.flags()));
                    continue;
                }
                if (!(annotation instanceof T32)) continue;
                this.allowConversion = true;
            }
        }
    }

    public String getCast() {
        String rc = this.annotation == null ? "" : this.annotation.cast();
        return TextSupport.cast(rc);
    }

    public boolean isPointer() {
        if (this.annotation == null) {
            return false;
        }
        return this.getFlag(ArgFlag.POINTER_ARG) || this.type.getWrappedClass() == Long.TYPE && this.getCast().endsWith("*)");
    }

    public JNIMethod getMethod() {
        return this.method;
    }

    public boolean getFlag(ArgFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public JNIType getType32() {
        return this.type.asType32(this.allowConversion);
    }

    public JNIType getType64() {
        return this.type.asType64(this.allowConversion);
    }

    public JNIClass getTypeClass() {
        ReflectType type = (ReflectType)this.getType32();
        return new ReflectClass(type.getWrappedClass());
    }

    public int getParameter() {
        return this.parameter;
    }
}

