/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileSupport {
    public static boolean write(byte[] bytes, File file) throws IOException {
        if (!FileSupport.equals(bytes, file)) {
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(bytes);
            }
            finally {
                out.close();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            int count;
            byte[] data = new byte[4096];
            while ((count = is.read(data, 0, data.length)) >= 0) {
                os.write(data, 0, count);
            }
        }
        finally {
            FileSupport.close(is);
            FileSupport.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(byte[] bytes, File file) throws IOException {
        boolean bl;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            bl = FileSupport.equals(new ByteArrayInputStream(bytes), new BufferedInputStream(is));
        }
        catch (FileNotFoundException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileSupport.close(is);
                throw throwable;
            }
            FileSupport.close(is);
            return bl2;
        }
        FileSupport.close(is);
        return bl;
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(OutputStream ioss) {
        try {
            if (ioss != null) {
                ioss.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean equals(InputStream is1, InputStream is2) throws IOException {
        int c1;
        do {
            int c2;
            if ((c1 = is1.read()) == (c2 = is2.read())) continue;
            return false;
        } while (c1 != -1);
        return true;
    }
}

