/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.util.List;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.generator.model.ReflectClass;

public class ConstantsGenerator
extends JNIGenerator {
    @Override
    public void generate(JNIClass clazz) {
        List<JNIField> fields = clazz.getDeclaredFields();
        this.generate(fields);
    }

    public void generate(List<JNIField> fields) {
        ConstantsGenerator.sortFields(fields);
        this.outputln("int main() {");
        for (JNIField field : fields) {
            if ((field.getModifiers() & 0x10) == 0) continue;
            this.generate(field);
        }
        this.outputln("}");
    }

    public void generate(JNIField field) {
        JNIType type = field.getType();
        this.output("\tprintf(\"public static final ");
        this.output(field.getType().getTypeSignature3(false));
        this.output(" ");
        this.output(field.getName());
        this.output(" = ");
        if (type.isType("java.lang.String") || type.isType("[B")) {
            this.output("\"%s\"");
        } else {
            this.output("0x%x");
        }
        this.output(";\\n\", ");
        this.output(field.getName());
        this.outputln(");");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java ConstantsGenerator <className1> <className2>");
            return;
        }
        try {
            ConstantsGenerator gen = new ConstantsGenerator();
            for (String clazzName : args) {
                Class<?> clazz = Class.forName(clazzName);
                gen.generate(new ReflectClass(clazz));
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

