/*******************************************************************************
 * Copyright (C) 2009, Progress Software Corporation and/or its 
 * subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
#include "jansi.h"
#include "hawtjni.h"
#include "jansi_structs.h"
#include "jansi_stats.h"

#define CLibrary_NATIVE(func) Java_org_fusesource_jansi_internal_CLibrary_##func

JNIEXPORT void JNICALL CLibrary_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(STDIN_FILENO)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STDIN_FILENO", "I"), (jint)STDIN_FILENO);
#endif
#if defined(STDIN_FILENO)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STDOUT_FILENO", "I"), (jint)STDOUT_FILENO);
#endif
#if defined(STDIN_FILENO)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STDERR_FILENO", "I"), (jint)STDERR_FILENO);
#endif
#if defined(HAVE_ISATTY)
	(*env)->SetStaticBooleanField(env, that, (*env)->GetStaticFieldID(env, that, "HAVE_ISATTY", "Z"), (jboolean)1);
#endif
   return;
}
#if defined(HAVE_ISATTY)
JNIEXPORT jint JNICALL CLibrary_NATIVE(isatty)
	(JNIEnv *env, jclass that, jint arg0)
{
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_isatty_FUNC);
	rc = isatty(arg0);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_isatty_FUNC);
	return rc;
}
#endif

#define Kernel32_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_##func

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(CloseHandle)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_CloseHandle_FUNC);
	rc = CloseHandle((HANDLE)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_CloseHandle_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(FillConsoleOutputCharacterW)
	(JNIEnv *env, jclass that, jlong arg0, jchar arg1, jint arg2, jobject arg3, jintArray arg4)
{
	COORD _arg3, *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_FillConsoleOutputCharacterW_FUNC);
	if (arg3) if ((lparg3 = getCOORDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = FillConsoleOutputCharacterW((HANDLE)(intptr_t)arg0, arg1, arg2, *lparg3, lparg4);
fail:
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) setCOORDFields(env, arg3, lparg3);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_FillConsoleOutputCharacterW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(FormatMessageW)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jint arg5, jlongArray arg6)
{
	jbyte *lparg4=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_FormatMessageW_FUNC);
#ifdef JNI_VERSION_1_2
	if (IS_JNI_1_2) {
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
		if (arg6) if ((lparg6 = (*env)->GetPrimitiveArrayCritical(env, arg6, NULL)) == NULL) goto fail;
	} else
#endif
	{
		if (arg4) if ((lparg4 = (*env)->GetByteArrayElements(env, arg4, NULL)) == NULL) goto fail;
		if (arg6) if ((lparg6 = (*env)->GetLongArrayElements(env, arg6, NULL)) == NULL) goto fail;
	}
	rc = FormatMessageW(arg0, (void *)(intptr_t)arg1, arg2, arg3, (void *)lparg4, arg5, (void *)NULL);
fail:
#ifdef JNI_VERSION_1_2
	if (IS_JNI_1_2) {
		if (arg6 && lparg6) (*env)->ReleasePrimitiveArrayCritical(env, arg6, lparg6, 0);
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, 0);
	} else
#endif
	{
		if (arg6 && lparg6) (*env)->ReleaseLongArrayElements(env, arg6, lparg6, 0);
		if (arg4 && lparg4) (*env)->ReleaseByteArrayElements(env, arg4, lparg4, 0);
	}
	Kernel32_NATIVE_EXIT(env, that, Kernel32_FormatMessageW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetConsoleMode)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1)
{
	jint *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetConsoleMode_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = GetConsoleMode((HANDLE)(intptr_t)arg0, lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetConsoleMode_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetConsoleScreenBufferInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	CONSOLE_SCREEN_BUFFER_INFO _arg1, *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetConsoleScreenBufferInfo_FUNC);
	if (arg1) if ((lparg1 = getCONSOLE_SCREEN_BUFFER_INFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = GetConsoleScreenBufferInfo((HANDLE)(intptr_t)arg0, lparg1);
fail:
	if (arg1 && lparg1) setCONSOLE_SCREEN_BUFFER_INFOFields(env, arg1, lparg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetConsoleScreenBufferInfo_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetLastError)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetLastError_FUNC);
	rc = GetLastError();
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetLastError_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jlong JNICALL Kernel32_NATIVE(GetStdHandle)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetStdHandle_FUNC);
	rc = (intptr_t)(HANDLE)GetStdHandle(arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetStdHandle_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(ReadConsoleInputW)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2, jintArray arg3)
{
	INPUT_RECORD _arg1, *lparg1=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_ReadConsoleInputW_FUNC);
	if (arg1) if ((lparg1 = getINPUT_RECORDFields(env, arg1, &_arg1)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = ReadConsoleInputW((HANDLE)(intptr_t)arg0, lparg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg1 && lparg1) setINPUT_RECORDFields(env, arg1, lparg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_ReadConsoleInputW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleCursorPosition)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	COORD _arg1, *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleCursorPosition_FUNC);
	if (arg1) if ((lparg1 = getCOORDFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = SetConsoleCursorPosition((HANDLE)(intptr_t)arg0, *lparg1);
fail:
	if (arg1 && lparg1) setCOORDFields(env, arg1, lparg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleCursorPosition_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleMode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleMode_FUNC);
	rc = SetConsoleMode((HANDLE)(intptr_t)arg0, arg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleMode_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleTextAttribute)
	(JNIEnv *env, jclass that, jlong arg0, jshort arg1)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleTextAttribute_FUNC);
	rc = SetConsoleTextAttribute((HANDLE)arg0, arg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleTextAttribute_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleTitle)
	(JNIEnv *env, jclass that, jstring arg0)
{
	const jchar *lparg0= NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleTitle_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetStringChars(env, arg0, NULL)) == NULL) goto fail;
	rc = SetConsoleTitle(lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseStringChars(env, arg0, lparg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleTitle_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(_1getch)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32__1getch_FUNC);
	rc = getch();
	Kernel32_NATIVE_EXIT(env, that, Kernel32__1getch_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT void JNICALL Kernel32_NATIVE(free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	Kernel32_NATIVE_ENTER(env, that, Kernel32_free_FUNC);
	free((void *)(intptr_t)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_free_FUNC);
}
#endif

JNIEXPORT void JNICALL Kernel32_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_BLUE", "S"), (jshort)FOREGROUND_BLUE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_GREEN", "S"), (jshort)FOREGROUND_GREEN);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_RED", "S"), (jshort)FOREGROUND_RED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_INTENSITY", "S"), (jshort)FOREGROUND_INTENSITY);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_BLUE", "S"), (jshort)BACKGROUND_BLUE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_GREEN", "S"), (jshort)BACKGROUND_GREEN);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_RED", "S"), (jshort)BACKGROUND_RED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_INTENSITY", "S"), (jshort)BACKGROUND_INTENSITY);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_LEADING_BYTE", "S"), (jshort)COMMON_LVB_LEADING_BYTE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_TRAILING_BYTE", "S"), (jshort)COMMON_LVB_TRAILING_BYTE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_GRID_HORIZONTAL", "S"), (jshort)COMMON_LVB_GRID_HORIZONTAL);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_GRID_LVERTICAL", "S"), (jshort)COMMON_LVB_GRID_LVERTICAL);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_GRID_RVERTICAL", "S"), (jshort)COMMON_LVB_GRID_RVERTICAL);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_REVERSE_VIDEO", "S"), (jshort)COMMON_LVB_REVERSE_VIDEO);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_UNDERSCORE", "S"), (jshort)COMMON_LVB_UNDERSCORE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "FORMAT_MESSAGE_FROM_SYSTEM", "I"), (jint)FORMAT_MESSAGE_FROM_SYSTEM);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STD_INPUT_HANDLE", "I"), (jint)STD_INPUT_HANDLE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STD_OUTPUT_HANDLE", "I"), (jint)STD_OUTPUT_HANDLE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STD_ERROR_HANDLE", "I"), (jint)STD_ERROR_HANDLE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "INVALID_HANDLE_VALUE", "I"), (jint)INVALID_HANDLE_VALUE);
#endif
   return;
}
#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jlong JNICALL Kernel32_NATIVE(malloc)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_malloc_FUNC);
	rc = (intptr_t)(void *)malloc((size_t)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_malloc_FUNC);
	return rc;
}
#endif

#define CONSOLE_SCREEN_BUFFER_INFO_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024CONSOLE_1SCREEN_1BUFFER_1INFO_##func

JNIEXPORT void JNICALL CONSOLE_SCREEN_BUFFER_INFO_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(CONSOLE_SCREEN_BUFFER_INFO));
#endif
   return;
}
#define COORD_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024COORD_##func

JNIEXPORT void JNICALL COORD_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(COORD));
#endif
   return;
}
#define INPUT_RECORD_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024INPUT_1RECORD_##func

JNIEXPORT void JNICALL INPUT_RECORD_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(INPUT_RECORD));
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "KEY_EVENT", "S"), (jshort)KEY_EVENT);
#endif
   return;
}
#define KEY_EVENT_RECORD_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024KEY_1EVENT_1RECORD_##func

JNIEXPORT void JNICALL KEY_EVENT_RECORD_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(KEY_EVENT_RECORD));
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "CAPSLOCK_ON", "I"), (jint)CAPSLOCK_ON);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "NUMLOCK_ON", "I"), (jint)NUMLOCK_ON);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SCROLLLOCK_ON", "I"), (jint)SCROLLLOCK_ON);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "ENHANCED_KEY", "I"), (jint)ENHANCED_KEY);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "LEFT_ALT_PRESSED", "I"), (jint)LEFT_ALT_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "LEFT_CTRL_PRESSED", "I"), (jint)LEFT_CTRL_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "RIGHT_ALT_PRESSED", "I"), (jint)RIGHT_ALT_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "RIGHT_CTRL_PRESSED", "I"), (jint)RIGHT_CTRL_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SHIFT_PRESSED", "I"), (jint)SHIFT_PRESSED);
#endif
   return;
}
#define SMALL_RECT_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024SMALL_1RECT_##func

JNIEXPORT void JNICALL SMALL_RECT_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(SMALL_RECT));
#endif
   return;
}
