/*******************************************************************************
 * Copyright (C) 2009, Progress Software Corporation and/or its 
 * subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
#include "jansi.h"
#include "hawtjni.h"
#include "jansi_structs.h"

#if defined(_WIN32) || defined(_WIN64)
typedef struct CONSOLE_SCREEN_BUFFER_INFO_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID size, cursorPosition, attributes, window, maximumWindowSize;
} CONSOLE_SCREEN_BUFFER_INFO_FID_CACHE;

CONSOLE_SCREEN_BUFFER_INFO_FID_CACHE CONSOLE_SCREEN_BUFFER_INFOFc;

void cacheCONSOLE_SCREEN_BUFFER_INFOFields(JNIEnv *env, jobject lpObject)
{
	if (CONSOLE_SCREEN_BUFFER_INFOFc.cached) return;
	CONSOLE_SCREEN_BUFFER_INFOFc.clazz = (*env)->GetObjectClass(env, lpObject);
	CONSOLE_SCREEN_BUFFER_INFOFc.size = (*env)->GetFieldID(env, CONSOLE_SCREEN_BUFFER_INFOFc.clazz, "size", "Lorg/fusesource/jansi/internal/Kernel32$COORD;");
	CONSOLE_SCREEN_BUFFER_INFOFc.cursorPosition = (*env)->GetFieldID(env, CONSOLE_SCREEN_BUFFER_INFOFc.clazz, "cursorPosition", "Lorg/fusesource/jansi/internal/Kernel32$COORD;");
	CONSOLE_SCREEN_BUFFER_INFOFc.attributes = (*env)->GetFieldID(env, CONSOLE_SCREEN_BUFFER_INFOFc.clazz, "attributes", "S");
	CONSOLE_SCREEN_BUFFER_INFOFc.window = (*env)->GetFieldID(env, CONSOLE_SCREEN_BUFFER_INFOFc.clazz, "window", "Lorg/fusesource/jansi/internal/Kernel32$SMALL_RECT;");
	CONSOLE_SCREEN_BUFFER_INFOFc.maximumWindowSize = (*env)->GetFieldID(env, CONSOLE_SCREEN_BUFFER_INFOFc.clazz, "maximumWindowSize", "Lorg/fusesource/jansi/internal/Kernel32$COORD;");
	CONSOLE_SCREEN_BUFFER_INFOFc.cached = 1;
}

CONSOLE_SCREEN_BUFFER_INFO *getCONSOLE_SCREEN_BUFFER_INFOFields(JNIEnv *env, jobject lpObject, CONSOLE_SCREEN_BUFFER_INFO *lpStruct)
{
	if (!CONSOLE_SCREEN_BUFFER_INFOFc.cached) cacheCONSOLE_SCREEN_BUFFER_INFOFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.size);
	if (lpObject1 != NULL) getCOORDFields(env, lpObject1, &lpStruct->dwSize);
	}
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.cursorPosition);
	if (lpObject1 != NULL) getCOORDFields(env, lpObject1, &lpStruct->dwCursorPosition);
	}
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->wAttributes = (*env)->GetShortField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.attributes);
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.window);
	if (lpObject1 != NULL) getSMALL_RECTFields(env, lpObject1, &lpStruct->srWindow);
	}
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.maximumWindowSize);
	if (lpObject1 != NULL) getCOORDFields(env, lpObject1, &lpStruct->dwMaximumWindowSize);
	}
#endif
	return lpStruct;
}

void setCONSOLE_SCREEN_BUFFER_INFOFields(JNIEnv *env, jobject lpObject, CONSOLE_SCREEN_BUFFER_INFO *lpStruct)
{
	if (!CONSOLE_SCREEN_BUFFER_INFOFc.cached) cacheCONSOLE_SCREEN_BUFFER_INFOFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.size);
	if (lpObject1 != NULL) setCOORDFields(env, lpObject1, &lpStruct->dwSize);
	}
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.cursorPosition);
	if (lpObject1 != NULL) setCOORDFields(env, lpObject1, &lpStruct->dwCursorPosition);
	}
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.attributes, (jshort)lpStruct->wAttributes);
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.window);
	if (lpObject1 != NULL) setSMALL_RECTFields(env, lpObject1, &lpStruct->srWindow);
	}
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, CONSOLE_SCREEN_BUFFER_INFOFc.maximumWindowSize);
	if (lpObject1 != NULL) setCOORDFields(env, lpObject1, &lpStruct->dwMaximumWindowSize);
	}
#endif
}
#endif

#if defined(_WIN32) || defined(_WIN64)
typedef struct COORD_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID x, y;
} COORD_FID_CACHE;

COORD_FID_CACHE COORDFc;

void cacheCOORDFields(JNIEnv *env, jobject lpObject)
{
	if (COORDFc.cached) return;
	COORDFc.clazz = (*env)->GetObjectClass(env, lpObject);
	COORDFc.x = (*env)->GetFieldID(env, COORDFc.clazz, "x", "S");
	COORDFc.y = (*env)->GetFieldID(env, COORDFc.clazz, "y", "S");
	COORDFc.cached = 1;
}

COORD *getCOORDFields(JNIEnv *env, jobject lpObject, COORD *lpStruct)
{
	if (!COORDFc.cached) cacheCOORDFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->X = (*env)->GetShortField(env, lpObject, COORDFc.x);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->Y = (*env)->GetShortField(env, lpObject, COORDFc.y);
#endif
	return lpStruct;
}

void setCOORDFields(JNIEnv *env, jobject lpObject, COORD *lpStruct)
{
	if (!COORDFc.cached) cacheCOORDFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, COORDFc.x, (jshort)lpStruct->X);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, COORDFc.y, (jshort)lpStruct->Y);
#endif
}
#endif

#if defined(_WIN32) || defined(_WIN64)
typedef struct INPUT_RECORD_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID eventType, keyEvent;
} INPUT_RECORD_FID_CACHE;

INPUT_RECORD_FID_CACHE INPUT_RECORDFc;

void cacheINPUT_RECORDFields(JNIEnv *env, jobject lpObject)
{
	if (INPUT_RECORDFc.cached) return;
	INPUT_RECORDFc.clazz = (*env)->GetObjectClass(env, lpObject);
	INPUT_RECORDFc.eventType = (*env)->GetFieldID(env, INPUT_RECORDFc.clazz, "eventType", "S");
	INPUT_RECORDFc.keyEvent = (*env)->GetFieldID(env, INPUT_RECORDFc.clazz, "keyEvent", "Lorg/fusesource/jansi/internal/Kernel32$KEY_EVENT_RECORD;");
	INPUT_RECORDFc.cached = 1;
}

INPUT_RECORD *getINPUT_RECORDFields(JNIEnv *env, jobject lpObject, INPUT_RECORD *lpStruct)
{
	if (!INPUT_RECORDFc.cached) cacheINPUT_RECORDFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->EventType = (*env)->GetShortField(env, lpObject, INPUT_RECORDFc.eventType);
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, INPUT_RECORDFc.keyEvent);
	if (lpObject1 != NULL) getKEY_EVENT_RECORDFields(env, lpObject1, &lpStruct->Event.KeyEvent);
	}
#endif
	return lpStruct;
}

void setINPUT_RECORDFields(JNIEnv *env, jobject lpObject, INPUT_RECORD *lpStruct)
{
	if (!INPUT_RECORDFc.cached) cacheINPUT_RECORDFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, INPUT_RECORDFc.eventType, (jshort)lpStruct->EventType);
#endif
#if defined(_WIN32) || defined(_WIN64)
	{
	jobject lpObject1 = (*env)->GetObjectField(env, lpObject, INPUT_RECORDFc.keyEvent);
	if (lpObject1 != NULL) setKEY_EVENT_RECORDFields(env, lpObject1, &lpStruct->Event.KeyEvent);
	}
#endif
}
#endif

#if defined(_WIN32) || defined(_WIN64)
typedef struct KEY_EVENT_RECORD_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID keyDown, repeatCount, keyCode, scanCode, uchar, controlKeyState;
} KEY_EVENT_RECORD_FID_CACHE;

KEY_EVENT_RECORD_FID_CACHE KEY_EVENT_RECORDFc;

void cacheKEY_EVENT_RECORDFields(JNIEnv *env, jobject lpObject)
{
	if (KEY_EVENT_RECORDFc.cached) return;
	KEY_EVENT_RECORDFc.clazz = (*env)->GetObjectClass(env, lpObject);
	KEY_EVENT_RECORDFc.keyDown = (*env)->GetFieldID(env, KEY_EVENT_RECORDFc.clazz, "keyDown", "Z");
	KEY_EVENT_RECORDFc.repeatCount = (*env)->GetFieldID(env, KEY_EVENT_RECORDFc.clazz, "repeatCount", "S");
	KEY_EVENT_RECORDFc.keyCode = (*env)->GetFieldID(env, KEY_EVENT_RECORDFc.clazz, "keyCode", "S");
	KEY_EVENT_RECORDFc.scanCode = (*env)->GetFieldID(env, KEY_EVENT_RECORDFc.clazz, "scanCode", "S");
	KEY_EVENT_RECORDFc.uchar = (*env)->GetFieldID(env, KEY_EVENT_RECORDFc.clazz, "uchar", "C");
	KEY_EVENT_RECORDFc.controlKeyState = (*env)->GetFieldID(env, KEY_EVENT_RECORDFc.clazz, "controlKeyState", "I");
	KEY_EVENT_RECORDFc.cached = 1;
}

KEY_EVENT_RECORD *getKEY_EVENT_RECORDFields(JNIEnv *env, jobject lpObject, KEY_EVENT_RECORD *lpStruct)
{
	if (!KEY_EVENT_RECORDFc.cached) cacheKEY_EVENT_RECORDFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->bKeyDown = (*env)->GetBooleanField(env, lpObject, KEY_EVENT_RECORDFc.keyDown);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->wRepeatCount = (*env)->GetShortField(env, lpObject, KEY_EVENT_RECORDFc.repeatCount);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->wVirtualKeyCode = (*env)->GetShortField(env, lpObject, KEY_EVENT_RECORDFc.keyCode);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->wVirtualScanCode = (*env)->GetShortField(env, lpObject, KEY_EVENT_RECORDFc.scanCode);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->uChar.UnicodeChar = (*env)->GetCharField(env, lpObject, KEY_EVENT_RECORDFc.uchar);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->dwControlKeyState = (*env)->GetIntField(env, lpObject, KEY_EVENT_RECORDFc.controlKeyState);
#endif
	return lpStruct;
}

void setKEY_EVENT_RECORDFields(JNIEnv *env, jobject lpObject, KEY_EVENT_RECORD *lpStruct)
{
	if (!KEY_EVENT_RECORDFc.cached) cacheKEY_EVENT_RECORDFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetBooleanField(env, lpObject, KEY_EVENT_RECORDFc.keyDown, (jboolean)lpStruct->bKeyDown);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, KEY_EVENT_RECORDFc.repeatCount, (jshort)lpStruct->wRepeatCount);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, KEY_EVENT_RECORDFc.keyCode, (jshort)lpStruct->wVirtualKeyCode);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, KEY_EVENT_RECORDFc.scanCode, (jshort)lpStruct->wVirtualScanCode);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetCharField(env, lpObject, KEY_EVENT_RECORDFc.uchar, (jchar)lpStruct->uChar.UnicodeChar);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetIntField(env, lpObject, KEY_EVENT_RECORDFc.controlKeyState, (jint)lpStruct->dwControlKeyState);
#endif
}
#endif

#if defined(_WIN32) || defined(_WIN64)
typedef struct SMALL_RECT_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID left, top, right, bottom;
} SMALL_RECT_FID_CACHE;

SMALL_RECT_FID_CACHE SMALL_RECTFc;

void cacheSMALL_RECTFields(JNIEnv *env, jobject lpObject)
{
	if (SMALL_RECTFc.cached) return;
	SMALL_RECTFc.clazz = (*env)->GetObjectClass(env, lpObject);
	SMALL_RECTFc.left = (*env)->GetFieldID(env, SMALL_RECTFc.clazz, "left", "S");
	SMALL_RECTFc.top = (*env)->GetFieldID(env, SMALL_RECTFc.clazz, "top", "S");
	SMALL_RECTFc.right = (*env)->GetFieldID(env, SMALL_RECTFc.clazz, "right", "S");
	SMALL_RECTFc.bottom = (*env)->GetFieldID(env, SMALL_RECTFc.clazz, "bottom", "S");
	SMALL_RECTFc.cached = 1;
}

SMALL_RECT *getSMALL_RECTFields(JNIEnv *env, jobject lpObject, SMALL_RECT *lpStruct)
{
	if (!SMALL_RECTFc.cached) cacheSMALL_RECTFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->Left = (*env)->GetShortField(env, lpObject, SMALL_RECTFc.left);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->Top = (*env)->GetShortField(env, lpObject, SMALL_RECTFc.top);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->Right = (*env)->GetShortField(env, lpObject, SMALL_RECTFc.right);
#endif
#if defined(_WIN32) || defined(_WIN64)
	lpStruct->Bottom = (*env)->GetShortField(env, lpObject, SMALL_RECTFc.bottom);
#endif
	return lpStruct;
}

void setSMALL_RECTFields(JNIEnv *env, jobject lpObject, SMALL_RECT *lpStruct)
{
	if (!SMALL_RECTFc.cached) cacheSMALL_RECTFields(env, lpObject);
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, SMALL_RECTFc.left, (jshort)lpStruct->Left);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, SMALL_RECTFc.top, (jshort)lpStruct->Top);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, SMALL_RECTFc.right, (jshort)lpStruct->Right);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetShortField(env, lpObject, SMALL_RECTFc.bottom, (jshort)lpStruct->Bottom);
#endif
}
#endif

