/*******************************************************************************
 * Copyright (C) 2009, Progress Software Corporation and/or its 
 * subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
#include "jansi.h"
#include "hawtjni.h"
#include "jansi_structs.h"
#include "jansi_stats.h"

#define CLibrary_NATIVE(func) Java_org_fusesource_jansi_internal_CLibrary_##func

JNIEXPORT void JNICALL CLibrary_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(STDIN_FILENO)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STDIN_FILENO", "I"), (jint)STDIN_FILENO);
#endif
#if defined(STDOUT_FILENO)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STDOUT_FILENO", "I"), (jint)STDOUT_FILENO);
#endif
#if defined(STDERR_FILENO)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STDERR_FILENO", "I"), (jint)STDERR_FILENO);
#endif
#if defined(HAVE_ISATTY)
	(*env)->SetStaticBooleanField(env, that, (*env)->GetStaticFieldID(env, that, "HAVE_ISATTY", "Z"), (jboolean)1);
#endif
#if defined(TCSANOW)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "TCSANOW", "I"), (jint)TCSANOW);
#endif
#if defined(TCSADRAIN)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "TCSADRAIN", "I"), (jint)TCSADRAIN);
#endif
#if defined(TCSAFLUSH)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "TCSAFLUSH", "I"), (jint)TCSAFLUSH);
#endif
#if defined(TIOCGETA)
	(*env)->SetStaticLongField(env, that, (*env)->GetStaticFieldID(env, that, "TIOCGETA", "J"), (jlong)TIOCGETA);
#endif
#if defined(TIOCSETA)
	(*env)->SetStaticLongField(env, that, (*env)->GetStaticFieldID(env, that, "TIOCSETA", "J"), (jlong)TIOCSETA);
#endif
#if defined(TIOCGETD)
	(*env)->SetStaticLongField(env, that, (*env)->GetStaticFieldID(env, that, "TIOCGETD", "J"), (jlong)TIOCGETD);
#endif
#if defined(TIOCSETD)
	(*env)->SetStaticLongField(env, that, (*env)->GetStaticFieldID(env, that, "TIOCSETD", "J"), (jlong)TIOCSETD);
#endif
#if defined(TIOCGWINSZ)
	(*env)->SetStaticLongField(env, that, (*env)->GetStaticFieldID(env, that, "TIOCGWINSZ", "J"), (jlong)TIOCGWINSZ);
#endif
#if defined(TIOCSWINSZ)
	(*env)->SetStaticLongField(env, that, (*env)->GetStaticFieldID(env, that, "TIOCSWINSZ", "J"), (jlong)TIOCSWINSZ);
#endif
   return;
}
#if defined(HAVE_IOCTL) && defined(HAVE_OPENPTY)
JNIEXPORT jint JNICALL CLibrary_NATIVE(ioctl__IJLorg_fusesource_jansi_internal_CLibrary_00024WinSize_2)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2)
{
	struct winsize _arg2, *lparg2=NULL;
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_ioctl__IJLorg_fusesource_jansi_internal_CLibrary_00024WinSize_2_FUNC);
	if (arg2) if ((lparg2 = getWinSizeFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)ioctl(arg0, arg1, (intptr_t)lparg2);
fail:
	if (arg2 && lparg2) setWinSizeFields(env, arg2, lparg2);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_ioctl__IJLorg_fusesource_jansi_internal_CLibrary_00024WinSize_2_FUNC);
	return rc;
}
#endif

#if defined(HAVE_IOCTL)
JNIEXPORT jint JNICALL CLibrary_NATIVE(ioctl__IJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2)
{
	jint *lparg2=NULL;
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_ioctl__IJ_3I_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)ioctl(arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_ioctl__IJ_3I_FUNC);
	return rc;
}
#endif

#if defined(HAVE_ISATTY)
JNIEXPORT jint JNICALL CLibrary_NATIVE(isatty)
	(JNIEnv *env, jclass that, jint arg0)
{
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_isatty_FUNC);
	rc = (jint)isatty(arg0);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_isatty_FUNC);
	return rc;
}
#endif

#if defined(HAVE_OPENPTY)
JNIEXPORT jint JNICALL CLibrary_NATIVE(openpty)
	(JNIEnv *env, jclass that, jintArray arg0, jintArray arg1, jbyteArray arg2, jobject arg3, jobject arg4)
{
	jint *lparg0=NULL;
	jint *lparg1=NULL;
	jbyte *lparg2=NULL;
	struct termios _arg3, *lparg3=NULL;
	struct winsize _arg4, *lparg4=NULL;
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_openpty_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetIntArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getTermiosFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getWinSizeFields(env, arg4, &_arg4)) == NULL) goto fail;
	rc = (jint)openpty((int *)lparg0, (int *)lparg1, (char *)lparg2, (struct termios *)lparg3, (struct winsize *)lparg4);
fail:
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseIntArrayElements(env, arg0, lparg0, 0);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_openpty_FUNC);
	return rc;
}
#endif

#if defined(HAVE_TCGETATTR)
JNIEXPORT jint JNICALL CLibrary_NATIVE(tcgetattr)
	(JNIEnv *env, jclass that, jint arg0, jobject arg1)
{
	struct termios _arg1, *lparg1=NULL;
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_tcgetattr_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jint)tcgetattr(arg0, (struct termios *)lparg1);
fail:
	if (arg1 && lparg1) setTermiosFields(env, arg1, lparg1);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_tcgetattr_FUNC);
	return rc;
}
#endif

#if defined(HAVE_TCSETATTR)
JNIEXPORT jint JNICALL CLibrary_NATIVE(tcsetattr)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jobject arg2)
{
	struct termios _arg2, *lparg2=NULL;
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_tcsetattr_FUNC);
	if (arg2) if ((lparg2 = getTermiosFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)tcsetattr(arg0, arg1, (struct termios *)lparg2);
fail:
	CLibrary_NATIVE_EXIT(env, that, CLibrary_tcsetattr_FUNC);
	return rc;
}
#endif

#if defined(HAVE_TTYNAME)
JNIEXPORT jstring JNICALL CLibrary_NATIVE(ttyname)
	(JNIEnv *env, jclass that, jint arg0)
{
	jstring rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_ttyname_FUNC);
	rc = (jstring)ttyname(arg0);
	CLibrary_NATIVE_EXIT(env, that, CLibrary_ttyname_FUNC);
	return rc;
}
#endif

#if defined(HAVE_TTYSLOT)
JNIEXPORT jint JNICALL CLibrary_NATIVE(ttyslot)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	CLibrary_NATIVE_ENTER(env, that, CLibrary_ttyslot_FUNC);
	rc = (jint)ttyslot();
	CLibrary_NATIVE_EXIT(env, that, CLibrary_ttyslot_FUNC);
	return rc;
}
#endif

#define Termios_NATIVE(func) Java_org_fusesource_jansi_internal_CLibrary_00024Termios_##func

JNIEXPORT void JNICALL Termios_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(HAVE_OPENPTY)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(struct termios));
#endif
   return;
}
#define WinSize_NATIVE(func) Java_org_fusesource_jansi_internal_CLibrary_00024WinSize_##func

JNIEXPORT void JNICALL WinSize_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(HAVE_OPENPTY)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(struct winsize));
#endif
   return;
}
#define Kernel32_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_##func

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(CloseHandle)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_CloseHandle_FUNC);
	rc = (jint)CloseHandle((HANDLE)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_CloseHandle_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(FillConsoleOutputAttribute)
	(JNIEnv *env, jclass that, jlong arg0, jshort arg1, jint arg2, jobject arg3, jintArray arg4)
{
	COORD _arg3, *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_FillConsoleOutputAttribute_FUNC);
	if (arg3) if ((lparg3 = getCOORDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)FillConsoleOutputAttribute((HANDLE)(intptr_t)arg0, arg1, arg2, *lparg3, lparg4);
fail:
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_FillConsoleOutputAttribute_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(FillConsoleOutputCharacterW)
	(JNIEnv *env, jclass that, jlong arg0, jchar arg1, jint arg2, jobject arg3, jintArray arg4)
{
	COORD _arg3, *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_FillConsoleOutputCharacterW_FUNC);
	if (arg3) if ((lparg3 = getCOORDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)FillConsoleOutputCharacterW((HANDLE)(intptr_t)arg0, arg1, arg2, *lparg3, lparg4);
fail:
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_FillConsoleOutputCharacterW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(FlushConsoleInputBuffer)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_FlushConsoleInputBuffer_FUNC);
	rc = (jint)FlushConsoleInputBuffer((HANDLE)(intptr_t)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_FlushConsoleInputBuffer_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(FormatMessageW)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jint arg5, jlongArray arg6)
{
	jbyte *lparg4=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_FormatMessageW_FUNC);
#ifdef JNI_VERSION_1_2
	if (IS_JNI_1_2) {
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
		if (arg6) if ((lparg6 = (*env)->GetPrimitiveArrayCritical(env, arg6, NULL)) == NULL) goto fail;
	} else
#endif
	{
		if (arg4) if ((lparg4 = (*env)->GetByteArrayElements(env, arg4, NULL)) == NULL) goto fail;
		if (arg6) if ((lparg6 = (*env)->GetLongArrayElements(env, arg6, NULL)) == NULL) goto fail;
	}
	rc = (jint)FormatMessageW(arg0, (void *)(intptr_t)arg1, arg2, arg3, (void *)lparg4, arg5, (void *)NULL);
fail:
#ifdef JNI_VERSION_1_2
	if (IS_JNI_1_2) {
		if (arg6 && lparg6) (*env)->ReleasePrimitiveArrayCritical(env, arg6, lparg6, 0);
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, 0);
	} else
#endif
	{
		if (arg6 && lparg6) (*env)->ReleaseLongArrayElements(env, arg6, lparg6, 0);
		if (arg4 && lparg4) (*env)->ReleaseByteArrayElements(env, arg4, lparg4, 0);
	}
	Kernel32_NATIVE_EXIT(env, that, Kernel32_FormatMessageW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetConsoleMode)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1)
{
	jint *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetConsoleMode_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetConsoleMode((HANDLE)(intptr_t)arg0, lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetConsoleMode_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetConsoleOutputCP)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetConsoleOutputCP_FUNC);
	rc = (jint)GetConsoleOutputCP();
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetConsoleOutputCP_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetConsoleScreenBufferInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	CONSOLE_SCREEN_BUFFER_INFO _arg1, *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetConsoleScreenBufferInfo_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jint)GetConsoleScreenBufferInfo((HANDLE)(intptr_t)arg0, lparg1);
fail:
	if (arg1 && lparg1) setCONSOLE_SCREEN_BUFFER_INFOFields(env, arg1, lparg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetConsoleScreenBufferInfo_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetLastError)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetLastError_FUNC);
	rc = (jint)GetLastError();
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetLastError_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(GetNumberOfConsoleInputEvents)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1)
{
	jint *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetNumberOfConsoleInputEvents_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetNumberOfConsoleInputEvents((HANDLE)(intptr_t)arg0, lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetNumberOfConsoleInputEvents_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jlong JNICALL Kernel32_NATIVE(GetStdHandle)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_GetStdHandle_FUNC);
	rc = (intptr_t)(HANDLE)GetStdHandle(arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_GetStdHandle_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(PeekConsoleInputW)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_PeekConsoleInputW_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)PeekConsoleInputW((HANDLE)(intptr_t)arg0, (PINPUT_RECORD)(intptr_t)arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_PeekConsoleInputW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(ReadConsoleInputW)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_ReadConsoleInputW_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)ReadConsoleInputW((HANDLE)(intptr_t)arg0, (PINPUT_RECORD)(intptr_t)arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_ReadConsoleInputW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(ScrollConsoleScreenBuffer)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jobject arg2, jobject arg3, jobject arg4)
{
	SMALL_RECT _arg1, *lparg1=NULL;
	SMALL_RECT _arg2, *lparg2=NULL;
	COORD _arg3, *lparg3=NULL;
	CHAR_INFO _arg4, *lparg4=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_ScrollConsoleScreenBuffer_FUNC);
	if (arg1) if ((lparg1 = getSMALL_RECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getSMALL_RECTFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getCOORDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getCHAR_INFOFields(env, arg4, &_arg4)) == NULL) goto fail;
	rc = (jint)ScrollConsoleScreenBuffer((HANDLE)(intptr_t)arg0, lparg1, lparg2, *lparg3, lparg4);
fail:
	Kernel32_NATIVE_EXIT(env, that, Kernel32_ScrollConsoleScreenBuffer_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleCursorPosition)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	COORD _arg1, *lparg1=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleCursorPosition_FUNC);
	if (arg1) if ((lparg1 = getCOORDFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jint)SetConsoleCursorPosition((HANDLE)(intptr_t)arg0, *lparg1);
fail:
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleCursorPosition_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleMode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleMode_FUNC);
	rc = (jint)SetConsoleMode((HANDLE)(intptr_t)arg0, arg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleMode_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleOutputCP)
	(JNIEnv *env, jclass that, jint arg0)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleOutputCP_FUNC);
	rc = (jint)SetConsoleOutputCP(arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleOutputCP_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleTextAttribute)
	(JNIEnv *env, jclass that, jlong arg0, jshort arg1)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleTextAttribute_FUNC);
	rc = (jint)SetConsoleTextAttribute((HANDLE)arg0, arg1);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleTextAttribute_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(SetConsoleTitle)
	(JNIEnv *env, jclass that, jstring arg0)
{
	const jchar *lparg0= NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_SetConsoleTitle_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetStringChars(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)SetConsoleTitle(lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseStringChars(env, arg0, lparg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_SetConsoleTitle_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(WriteConsoleW)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jintArray arg3, jlong arg4)
{
	jchar *lparg1=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_WriteConsoleW_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)WriteConsoleW((HANDLE)(intptr_t)arg0, lparg1, arg2, lparg3, (LPVOID)(intptr_t)arg4);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_WriteConsoleW_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jint JNICALL Kernel32_NATIVE(_1getch)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32__1getch_FUNC);
	rc = (jint)getch();
	Kernel32_NATIVE_EXIT(env, that, Kernel32__1getch_FUNC);
	return rc;
}
#endif

#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT void JNICALL Kernel32_NATIVE(free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	Kernel32_NATIVE_ENTER(env, that, Kernel32_free_FUNC);
	free((void *)(intptr_t)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_free_FUNC);
}
#endif

JNIEXPORT void JNICALL Kernel32_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_BLUE", "S"), (jshort)FOREGROUND_BLUE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_GREEN", "S"), (jshort)FOREGROUND_GREEN);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_RED", "S"), (jshort)FOREGROUND_RED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "FOREGROUND_INTENSITY", "S"), (jshort)FOREGROUND_INTENSITY);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_BLUE", "S"), (jshort)BACKGROUND_BLUE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_GREEN", "S"), (jshort)BACKGROUND_GREEN);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_RED", "S"), (jshort)BACKGROUND_RED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "BACKGROUND_INTENSITY", "S"), (jshort)BACKGROUND_INTENSITY);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_LEADING_BYTE", "S"), (jshort)COMMON_LVB_LEADING_BYTE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_TRAILING_BYTE", "S"), (jshort)COMMON_LVB_TRAILING_BYTE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_GRID_HORIZONTAL", "S"), (jshort)COMMON_LVB_GRID_HORIZONTAL);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_GRID_LVERTICAL", "S"), (jshort)COMMON_LVB_GRID_LVERTICAL);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_GRID_RVERTICAL", "S"), (jshort)COMMON_LVB_GRID_RVERTICAL);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_REVERSE_VIDEO", "S"), (jshort)COMMON_LVB_REVERSE_VIDEO);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "COMMON_LVB_UNDERSCORE", "S"), (jshort)COMMON_LVB_UNDERSCORE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "FORMAT_MESSAGE_FROM_SYSTEM", "I"), (jint)FORMAT_MESSAGE_FROM_SYSTEM);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STD_INPUT_HANDLE", "I"), (jint)STD_INPUT_HANDLE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STD_OUTPUT_HANDLE", "I"), (jint)STD_OUTPUT_HANDLE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "STD_ERROR_HANDLE", "I"), (jint)STD_ERROR_HANDLE);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "INVALID_HANDLE_VALUE", "I"), (jint)INVALID_HANDLE_VALUE);
#endif
   return;
}
#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT jlong JNICALL Kernel32_NATIVE(malloc)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	Kernel32_NATIVE_ENTER(env, that, Kernel32_malloc_FUNC);
	rc = (intptr_t)(void *)malloc((size_t)arg0);
	Kernel32_NATIVE_EXIT(env, that, Kernel32_malloc_FUNC);
	return rc;
}
#endif

#define CHAR_INFO_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024CHAR_1INFO_##func

JNIEXPORT void JNICALL CHAR_INFO_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(CHAR_INFO));
#endif
   return;
}
#define CONSOLE_SCREEN_BUFFER_INFO_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024CONSOLE_1SCREEN_1BUFFER_1INFO_##func

JNIEXPORT void JNICALL CONSOLE_SCREEN_BUFFER_INFO_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(CONSOLE_SCREEN_BUFFER_INFO));
#endif
   return;
}
#define COORD_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024COORD_##func

JNIEXPORT void JNICALL COORD_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(COORD));
#endif
   return;
}
#define INPUT_RECORD_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024INPUT_1RECORD_##func

JNIEXPORT void JNICALL INPUT_RECORD_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(INPUT_RECORD));
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticShortField(env, that, (*env)->GetStaticFieldID(env, that, "KEY_EVENT", "S"), (jshort)KEY_EVENT);
#endif
   return;
}
#if defined(_WIN32) || defined(_WIN64)
JNIEXPORT void JNICALL INPUT_RECORD_NATIVE(memmove)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jlong arg2)
{
	INPUT_RECORD _arg0, *lparg0=NULL;
	INPUT_RECORD_NATIVE_ENTER(env, that, INPUT_RECORD_memmove_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)(intptr_t)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setINPUT_RECORDFields(env, arg0, lparg0);
	INPUT_RECORD_NATIVE_EXIT(env, that, INPUT_RECORD_memmove_FUNC);
}
#endif

#define KEY_EVENT_RECORD_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024KEY_1EVENT_1RECORD_##func

JNIEXPORT void JNICALL KEY_EVENT_RECORD_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(KEY_EVENT_RECORD));
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "CAPSLOCK_ON", "I"), (jint)CAPSLOCK_ON);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "NUMLOCK_ON", "I"), (jint)NUMLOCK_ON);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SCROLLLOCK_ON", "I"), (jint)SCROLLLOCK_ON);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "ENHANCED_KEY", "I"), (jint)ENHANCED_KEY);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "LEFT_ALT_PRESSED", "I"), (jint)LEFT_ALT_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "LEFT_CTRL_PRESSED", "I"), (jint)LEFT_CTRL_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "RIGHT_ALT_PRESSED", "I"), (jint)RIGHT_ALT_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "RIGHT_CTRL_PRESSED", "I"), (jint)RIGHT_CTRL_PRESSED);
#endif
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SHIFT_PRESSED", "I"), (jint)SHIFT_PRESSED);
#endif
   return;
}
#define SMALL_RECT_NATIVE(func) Java_org_fusesource_jansi_internal_Kernel32_00024SMALL_1RECT_##func

JNIEXPORT void JNICALL SMALL_RECT_NATIVE(init)(JNIEnv *env, jclass that)
{
#if defined(_WIN32) || defined(_WIN64)
	(*env)->SetStaticIntField(env, that, (*env)->GetStaticFieldID(env, that, "SIZEOF", "I"), (jint)sizeof(SMALL_RECT));
#endif
   return;
}
