/*******************************************************************************
 * Copyright (C) 2009, Progress Software Corporation and/or its 
 * subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
#include "hawtjni.h"
#include "jansi_stats.h"

#ifdef NATIVE_STATS

int CLibrary_nativeFunctionCount = 9;
int CLibrary_nativeFunctionCallCount[9];
char * CLibrary_nativeFunctionNames[] = {
	"init",
	"ioctl__IJLorg_fusesource_jansi_internal_CLibrary_00024WinSize_2",
	"ioctl__IJ_3I",
	"isatty",
	"openpty",
	"tcgetattr",
	"tcsetattr",
	"ttyname",
	"ttyslot",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(CLibrary_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return CLibrary_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(CLibrary_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, CLibrary_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(CLibrary_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return CLibrary_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int Termios_nativeFunctionCount = 1;
int Termios_nativeFunctionCallCount[1];
char * Termios_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(Termios_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return Termios_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(Termios_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, Termios_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(Termios_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return Termios_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int WinSize_nativeFunctionCount = 1;
int WinSize_nativeFunctionCallCount[1];
char * WinSize_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(WinSize_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return WinSize_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(WinSize_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, WinSize_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(WinSize_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return WinSize_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int Kernel32_nativeFunctionCount = 24;
int Kernel32_nativeFunctionCallCount[24];
char * Kernel32_nativeFunctionNames[] = {
	"CloseHandle",
	"FillConsoleOutputAttribute",
	"FillConsoleOutputCharacterW",
	"FlushConsoleInputBuffer",
	"FormatMessageW",
	"GetConsoleMode",
	"GetConsoleOutputCP",
	"GetConsoleScreenBufferInfo",
	"GetLastError",
	"GetNumberOfConsoleInputEvents",
	"GetStdHandle",
	"PeekConsoleInputW",
	"ReadConsoleInputW",
	"ScrollConsoleScreenBuffer",
	"SetConsoleCursorPosition",
	"SetConsoleMode",
	"SetConsoleOutputCP",
	"SetConsoleTextAttribute",
	"SetConsoleTitle",
	"WriteConsoleW",
	"_1getch",
	"free",
	"init",
	"malloc",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(Kernel32_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return Kernel32_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(Kernel32_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, Kernel32_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(Kernel32_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return Kernel32_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int CHAR_INFO_nativeFunctionCount = 1;
int CHAR_INFO_nativeFunctionCallCount[1];
char * CHAR_INFO_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(CHAR_1INFO_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return CHAR_INFO_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(CHAR_1INFO_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, CHAR_INFO_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(CHAR_1INFO_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return CHAR_INFO_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCount = 1;
int CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCallCount[1];
char * CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(CONSOLE_1SCREEN_1BUFFER_1INFO_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(CONSOLE_1SCREEN_1BUFFER_1INFO_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(CONSOLE_1SCREEN_1BUFFER_1INFO_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int COORD_nativeFunctionCount = 1;
int COORD_nativeFunctionCallCount[1];
char * COORD_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(COORD_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return COORD_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(COORD_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, COORD_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(COORD_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return COORD_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int INPUT_RECORD_nativeFunctionCount = 2;
int INPUT_RECORD_nativeFunctionCallCount[2];
char * INPUT_RECORD_nativeFunctionNames[] = {
	"init",
	"memmove",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(INPUT_1RECORD_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return INPUT_RECORD_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(INPUT_1RECORD_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, INPUT_RECORD_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(INPUT_1RECORD_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return INPUT_RECORD_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int KEY_EVENT_RECORD_nativeFunctionCount = 1;
int KEY_EVENT_RECORD_nativeFunctionCallCount[1];
char * KEY_EVENT_RECORD_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(KEY_1EVENT_1RECORD_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return KEY_EVENT_RECORD_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(KEY_1EVENT_1RECORD_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, KEY_EVENT_RECORD_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(KEY_1EVENT_1RECORD_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return KEY_EVENT_RECORD_nativeFunctionCallCount[index];
}

#endif
#ifdef NATIVE_STATS

int SMALL_RECT_nativeFunctionCount = 1;
int SMALL_RECT_nativeFunctionCallCount[1];
char * SMALL_RECT_nativeFunctionNames[] = {
	"init",
};

#define STATS_NATIVE(func) Java_org_fusesource_hawtjni_runtime_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(SMALL_1RECT_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return SMALL_RECT_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(SMALL_1RECT_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, SMALL_RECT_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(SMALL_1RECT_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return SMALL_RECT_nativeFunctionCallCount[index];
}

#endif
