/*******************************************************************************
 * Copyright (C) 2009, Progress Software Corporation and/or its 
 * subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
#ifdef NATIVE_STATS
extern int CLibrary_nativeFunctionCount;
extern int CLibrary_nativeFunctionCallCount[];
extern char* CLibrary_nativeFunctionNames[];
#define CLibrary_NATIVE_ENTER(env, that, func) CLibrary_nativeFunctionCallCount[func]++;
#define CLibrary_NATIVE_EXIT(env, that, func) 
#else
#ifndef CLibrary_NATIVE_ENTER
#define CLibrary_NATIVE_ENTER(env, that, func) 
#endif
#ifndef CLibrary_NATIVE_EXIT
#define CLibrary_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	CLibrary_init_FUNC,
	CLibrary_ioctl__IJLorg_fusesource_jansi_internal_CLibrary_00024WinSize_2_FUNC,
	CLibrary_ioctl__IJ_3I_FUNC,
	CLibrary_isatty_FUNC,
	CLibrary_openpty_FUNC,
	CLibrary_tcgetattr_FUNC,
	CLibrary_tcsetattr_FUNC,
	CLibrary_ttyname_FUNC,
	CLibrary_ttyslot_FUNC,
} CLibrary_FUNCS;
#ifdef NATIVE_STATS
extern int Termios_nativeFunctionCount;
extern int Termios_nativeFunctionCallCount[];
extern char* Termios_nativeFunctionNames[];
#define Termios_NATIVE_ENTER(env, that, func) Termios_nativeFunctionCallCount[func]++;
#define Termios_NATIVE_EXIT(env, that, func) 
#else
#ifndef Termios_NATIVE_ENTER
#define Termios_NATIVE_ENTER(env, that, func) 
#endif
#ifndef Termios_NATIVE_EXIT
#define Termios_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	Termios_init_FUNC,
} Termios_FUNCS;
#ifdef NATIVE_STATS
extern int WinSize_nativeFunctionCount;
extern int WinSize_nativeFunctionCallCount[];
extern char* WinSize_nativeFunctionNames[];
#define WinSize_NATIVE_ENTER(env, that, func) WinSize_nativeFunctionCallCount[func]++;
#define WinSize_NATIVE_EXIT(env, that, func) 
#else
#ifndef WinSize_NATIVE_ENTER
#define WinSize_NATIVE_ENTER(env, that, func) 
#endif
#ifndef WinSize_NATIVE_EXIT
#define WinSize_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	WinSize_init_FUNC,
} WinSize_FUNCS;
#ifdef NATIVE_STATS
extern int Kernel32_nativeFunctionCount;
extern int Kernel32_nativeFunctionCallCount[];
extern char* Kernel32_nativeFunctionNames[];
#define Kernel32_NATIVE_ENTER(env, that, func) Kernel32_nativeFunctionCallCount[func]++;
#define Kernel32_NATIVE_EXIT(env, that, func) 
#else
#ifndef Kernel32_NATIVE_ENTER
#define Kernel32_NATIVE_ENTER(env, that, func) 
#endif
#ifndef Kernel32_NATIVE_EXIT
#define Kernel32_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	Kernel32_CloseHandle_FUNC,
	Kernel32_FillConsoleOutputAttribute_FUNC,
	Kernel32_FillConsoleOutputCharacterW_FUNC,
	Kernel32_FlushConsoleInputBuffer_FUNC,
	Kernel32_FormatMessageW_FUNC,
	Kernel32_GetConsoleMode_FUNC,
	Kernel32_GetConsoleOutputCP_FUNC,
	Kernel32_GetConsoleScreenBufferInfo_FUNC,
	Kernel32_GetLastError_FUNC,
	Kernel32_GetNumberOfConsoleInputEvents_FUNC,
	Kernel32_GetStdHandle_FUNC,
	Kernel32_PeekConsoleInputW_FUNC,
	Kernel32_ReadConsoleInputW_FUNC,
	Kernel32_ScrollConsoleScreenBuffer_FUNC,
	Kernel32_SetConsoleCursorPosition_FUNC,
	Kernel32_SetConsoleMode_FUNC,
	Kernel32_SetConsoleOutputCP_FUNC,
	Kernel32_SetConsoleTextAttribute_FUNC,
	Kernel32_SetConsoleTitle_FUNC,
	Kernel32_WriteConsoleW_FUNC,
	Kernel32__1getch_FUNC,
	Kernel32_free_FUNC,
	Kernel32_init_FUNC,
	Kernel32_malloc_FUNC,
} Kernel32_FUNCS;
#ifdef NATIVE_STATS
extern int CHAR_INFO_nativeFunctionCount;
extern int CHAR_INFO_nativeFunctionCallCount[];
extern char* CHAR_INFO_nativeFunctionNames[];
#define CHAR_INFO_NATIVE_ENTER(env, that, func) CHAR_INFO_nativeFunctionCallCount[func]++;
#define CHAR_INFO_NATIVE_EXIT(env, that, func) 
#else
#ifndef CHAR_INFO_NATIVE_ENTER
#define CHAR_INFO_NATIVE_ENTER(env, that, func) 
#endif
#ifndef CHAR_INFO_NATIVE_EXIT
#define CHAR_INFO_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	CHAR_INFO_init_FUNC,
} CHAR_INFO_FUNCS;
#ifdef NATIVE_STATS
extern int CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCount;
extern int CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCallCount[];
extern char* CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionNames[];
#define CONSOLE_SCREEN_BUFFER_INFO_NATIVE_ENTER(env, that, func) CONSOLE_SCREEN_BUFFER_INFO_nativeFunctionCallCount[func]++;
#define CONSOLE_SCREEN_BUFFER_INFO_NATIVE_EXIT(env, that, func) 
#else
#ifndef CONSOLE_SCREEN_BUFFER_INFO_NATIVE_ENTER
#define CONSOLE_SCREEN_BUFFER_INFO_NATIVE_ENTER(env, that, func) 
#endif
#ifndef CONSOLE_SCREEN_BUFFER_INFO_NATIVE_EXIT
#define CONSOLE_SCREEN_BUFFER_INFO_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	CONSOLE_SCREEN_BUFFER_INFO_init_FUNC,
} CONSOLE_SCREEN_BUFFER_INFO_FUNCS;
#ifdef NATIVE_STATS
extern int COORD_nativeFunctionCount;
extern int COORD_nativeFunctionCallCount[];
extern char* COORD_nativeFunctionNames[];
#define COORD_NATIVE_ENTER(env, that, func) COORD_nativeFunctionCallCount[func]++;
#define COORD_NATIVE_EXIT(env, that, func) 
#else
#ifndef COORD_NATIVE_ENTER
#define COORD_NATIVE_ENTER(env, that, func) 
#endif
#ifndef COORD_NATIVE_EXIT
#define COORD_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	COORD_init_FUNC,
} COORD_FUNCS;
#ifdef NATIVE_STATS
extern int INPUT_RECORD_nativeFunctionCount;
extern int INPUT_RECORD_nativeFunctionCallCount[];
extern char* INPUT_RECORD_nativeFunctionNames[];
#define INPUT_RECORD_NATIVE_ENTER(env, that, func) INPUT_RECORD_nativeFunctionCallCount[func]++;
#define INPUT_RECORD_NATIVE_EXIT(env, that, func) 
#else
#ifndef INPUT_RECORD_NATIVE_ENTER
#define INPUT_RECORD_NATIVE_ENTER(env, that, func) 
#endif
#ifndef INPUT_RECORD_NATIVE_EXIT
#define INPUT_RECORD_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	INPUT_RECORD_init_FUNC,
	INPUT_RECORD_memmove_FUNC,
} INPUT_RECORD_FUNCS;
#ifdef NATIVE_STATS
extern int KEY_EVENT_RECORD_nativeFunctionCount;
extern int KEY_EVENT_RECORD_nativeFunctionCallCount[];
extern char* KEY_EVENT_RECORD_nativeFunctionNames[];
#define KEY_EVENT_RECORD_NATIVE_ENTER(env, that, func) KEY_EVENT_RECORD_nativeFunctionCallCount[func]++;
#define KEY_EVENT_RECORD_NATIVE_EXIT(env, that, func) 
#else
#ifndef KEY_EVENT_RECORD_NATIVE_ENTER
#define KEY_EVENT_RECORD_NATIVE_ENTER(env, that, func) 
#endif
#ifndef KEY_EVENT_RECORD_NATIVE_EXIT
#define KEY_EVENT_RECORD_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	KEY_EVENT_RECORD_init_FUNC,
} KEY_EVENT_RECORD_FUNCS;
#ifdef NATIVE_STATS
extern int SMALL_RECT_nativeFunctionCount;
extern int SMALL_RECT_nativeFunctionCallCount[];
extern char* SMALL_RECT_nativeFunctionNames[];
#define SMALL_RECT_NATIVE_ENTER(env, that, func) SMALL_RECT_nativeFunctionCallCount[func]++;
#define SMALL_RECT_NATIVE_EXIT(env, that, func) 
#else
#ifndef SMALL_RECT_NATIVE_ENTER
#define SMALL_RECT_NATIVE_ENTER(env, that, func) 
#endif
#ifndef SMALL_RECT_NATIVE_EXIT
#define SMALL_RECT_NATIVE_EXIT(env, that, func) 
#endif
#endif

typedef enum {
	SMALL_RECT_init_FUNC,
} SMALL_RECT_FUNCS;
