/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.leveldbjni.internal;

import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.fusesource.leveldbjni.internal.NativeIterator;
import org.iq80.leveldb.DBIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JniDBIterator
implements DBIterator {
    private final NativeIterator iterator;

    JniDBIterator(NativeIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public void close() {
        this.iterator.delete();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(byte[] key) {
        try {
            this.iterator.seek(key);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound()) {
                throw new NoSuchElementException();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToFirst() {
        this.iterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.iterator.seekToLast();
    }

    @Override
    public Map.Entry<byte[], byte[]> peekNext() {
        if (!this.iterator.isValid()) {
            throw new NoSuchElementException();
        }
        try {
            return new AbstractMap.SimpleImmutableEntry<byte[], byte[]>(this.iterator.key(), this.iterator.value());
        }
        catch (NativeDB.DBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.isValid();
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        Map.Entry<byte[], byte[]> rc = this.peekNext();
        try {
            this.iterator.next();
        }
        catch (NativeDB.DBException e) {
            throw new RuntimeException(e);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrev() {
        boolean bl;
        if (!this.iterator.isValid()) {
            return false;
        }
        this.iterator.prev();
        try {
            bl = this.iterator.isValid();
        }
        catch (Throwable throwable) {
            try {
                this.iterator.next();
                throw throwable;
            }
            catch (NativeDB.DBException e) {
                throw new RuntimeException(e);
            }
        }
        this.iterator.next();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<byte[], byte[]> peekPrev() {
        Map.Entry<byte[], byte[]> entry;
        this.iterator.prev();
        try {
            entry = this.peekNext();
        }
        catch (Throwable throwable) {
            try {
                this.iterator.next();
                throw throwable;
            }
            catch (NativeDB.DBException e) {
                throw new RuntimeException(e);
            }
        }
        this.iterator.next();
        return entry;
    }

    @Override
    public Map.Entry<byte[], byte[]> prev() {
        Map.Entry<byte[], byte[]> rc = this.peekPrev();
        try {
            this.iterator.prev();
        }
        catch (NativeDB.DBException e) {
            throw new RuntimeException(e);
        }
        return rc;
    }
}

