/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.Iterator;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.fo.properties.StringProperty;

public final class FontFamilyProperty
extends ListProperty {
    private static final PropertyCache cache = new PropertyCache();
    private int hash = 0;

    private FontFamilyProperty(Property prop) {
        this.addProperty(prop);
    }

    private FontFamilyProperty() {
    }

    public void addProperty(Property prop) {
        if (prop.getList() != null) {
            this.list.addAll(prop.getList());
        } else {
            super.addProperty(prop);
        }
    }

    public String getString() {
        if (this.list.size() > 0) {
            Property first = (Property)this.list.get(0);
            return first.getString();
        }
        return super.getString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FontFamilyProperty) {
            FontFamilyProperty ffp = (FontFamilyProperty)o;
            return this.list != null && ((Object)this.list).equals(ffp.list);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int hash = 17;
            Iterator i = this.list.iterator();
            while (i.hasNext()) {
                Property p = (Property)i.next();
                hash = 37 * hash + (p == null ? 0 : p.hashCode());
            }
            this.hash = hash;
        }
        return this.hash;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
            if ("inherit".equals(value)) {
                return super.make(propertyList, value, fo);
            }
            FontFamilyProperty prop = new FontFamilyProperty();
            int startIndex = 0;
            int commaIndex = value.indexOf(44);
            boolean parsed = false;
            while (!parsed) {
                String tmpVal;
                if (commaIndex == -1) {
                    tmpVal = value.substring(startIndex).trim();
                    parsed = true;
                } else {
                    tmpVal = value.substring(startIndex, commaIndex).trim();
                    startIndex = commaIndex + 1;
                    commaIndex = value.indexOf(44, startIndex);
                }
                int aposIndex = tmpVal.indexOf(39);
                int quoteIndex = tmpVal.indexOf(34);
                if (aposIndex != -1 || quoteIndex != -1) {
                    int qChar;
                    int n = qChar = aposIndex == -1 ? 34 : 39;
                    if (tmpVal.lastIndexOf(qChar) != tmpVal.length() - 1) {
                        Property.log.warn("Skipping malformed value for font-family: " + tmpVal + " in \"" + value + "\".");
                        tmpVal = "";
                    } else {
                        tmpVal = tmpVal.substring(1, tmpVal.length() - 1);
                    }
                }
                if ("".equals(tmpVal)) continue;
                int dblSpaceIndex = tmpVal.indexOf("  ");
                while (dblSpaceIndex != -1) {
                    tmpVal = tmpVal.substring(0, dblSpaceIndex) + tmpVal.substring(dblSpaceIndex + 1);
                    dblSpaceIndex = tmpVal.indexOf("  ");
                }
                prop.addProperty(StringProperty.getInstance(tmpVal));
            }
            return cache.fetch(prop);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) {
            if (p instanceof FontFamilyProperty) {
                return p;
            }
            return new FontFamilyProperty(p);
        }
    }
}

