/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractPageObject;
import org.apache.fop.render.afp.modca.IncludePageOverlay;
import org.apache.fop.render.afp.modca.Overlay;
import org.apache.fop.render.afp.modca.ResourceGroup;

public class PageObject
extends AbstractPageObject {
    private ResourceGroup resourceGroup = null;

    public PageObject(String name, int width, int height, int rotation, int widthResolution, int heightResolution) {
        super(name, width, height, rotation, widthResolution, heightResolution);
    }

    public void addOverlay(Overlay overlay) {
        if (this.resourceGroup == null) {
            this.resourceGroup = new ResourceGroup();
        }
        this.resourceGroup.addOverlay(overlay);
    }

    public void createIncludePageOverlay(String name, int x, int y, int orientation) {
        IncludePageOverlay ipo = new IncludePageOverlay(name, x, y, orientation);
        this.objects.add(ipo);
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this.resourceGroup != null) {
            this.resourceGroup.writeDataStream(os);
        }
        this.activeEnvironmentGroup.writeDataStream(os);
        this.writeObjectList(this.segments, os);
        this.writeObjectList(this.tagLogicalElements, os);
        this.writeObjectList(this.objects, os);
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -88;
        data[5] = -81;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        data[0] = 90;
        data[1] = 0;
        data[2] = 16;
        data[3] = -45;
        data[4] = -87;
        data[5] = -81;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[9 + i] = this.nameBytes[i];
        }
        os.write(data);
    }
}

