/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.module.docbook.DocbookMarkup;
import org.apache.maven.doxia.module.docbook.DocbookUtils;
import org.apache.maven.doxia.module.docbook.SimplifiedDocbookMarkup;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocBookParser
extends AbstractXmlParser
implements DocbookMarkup,
SimplifiedDocbookMarkup {
    private int level;
    private boolean isBold;
    private boolean inHead;
    private boolean ignore;
    private boolean simpleTag;
    private char trademark;
    private final Stack parent = new Stack();
    private static final Collection HIER_ELEMENTS = new HashSet();
    private static final Collection META_ELEMENTS = new HashSet();
    private static final Collection ARTICLEINFO_ELEMENTS = new HashSet();
    private static final Collection VERBATIM_ELEMENTS = new HashSet();
    private static final Collection BOLD_ELEMENTS = new HashSet();
    private static final Collection ITALIC_ELEMENTS = new HashSet();
    private static final Collection MONOSPACE_ELEMENTS = new HashSet();
    private static final Collection IGNORABLE_ELEMENTS = new HashSet();

    protected void init() {
        super.init();
        this.parent.clear();
        this.trademark = '\u0000';
        this.level = 0;
        this.isBold = false;
        this.inHead = false;
        this.ignore = false;
        this.simpleTag = false;
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (this.inHead && !META_ELEMENTS.contains(parser.getName()) && this.isParent(SimplifiedDocbookMarkup.ARTICLE_TAG.toString())) {
            sink.head_();
            this.inHead = false;
            sink.body();
        }
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        this.simpleTag = parser.isEmptyElementTag();
        if (parser.getName().equals(SimplifiedDocbookMarkup.ARTICLE_TAG.toString())) {
            this.handleArticleStart(sink, attribs);
        } else if (this.isParent(SimplifiedDocbookMarkup.ARTICLEINFO_TAG.toString())) {
            this.handleArticleInfoStartTags(parser.getName(), sink, attribs);
        } else if (parser.getName().equals(SimplifiedDocbookMarkup.ARTICLEINFO_TAG.toString())) {
            this.parent.push(SimplifiedDocbookMarkup.ARTICLEINFO_TAG.toString());
        } else if (parser.getName().equals(SimplifiedDocbookMarkup.FOOTNOTE_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.SECTIONINFO_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.VIDEOOBJECT_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.AUDIOOBJECT_TAG.toString())) {
            this.parent.push(parser.getName());
            this.ignore = true;
        } else {
            if (this.isParent(SimplifiedDocbookMarkup.FOOTNOTE_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.AUDIOOBJECT_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.VIDEOOBJECT_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.SECTIONINFO_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.ENTRYTBL_TAG.toString())) {
                return;
            }
            if (HIER_ELEMENTS.contains(parser.getName())) {
                this.handleSectionElements(sink, parser.getName(), attribs);
            } else {
                if (this.listStartTags(parser.getName(), sink, attribs)) {
                    return;
                }
                if (this.mediaStartTag(parser.getName(), sink, attribs)) {
                    return;
                }
                if (this.tableStartTags(parser.getName(), sink, attribs)) {
                    return;
                }
                if (parser.getName().equals(SimplifiedDocbookMarkup.PARA_TAG.toString())) {
                    this.handleParaStart(sink, attribs);
                } else {
                    if (this.styleStartTags(parser.getName(), sink, attribs)) {
                        return;
                    }
                    if (parser.getName().equals(SimplifiedDocbookMarkup.TITLE_TAG.toString())) {
                        this.handleTitleStart(sink, attribs);
                    } else if (parser.getName().equals(SimplifiedDocbookMarkup.EMAIL_TAG.toString())) {
                        this.handleEmailStart(parser, sink, attribs);
                    } else {
                        if (this.linkStartTag(parser.getName(), sink, attribs)) {
                            return;
                        }
                        if (parser.getName().equals(SimplifiedDocbookMarkup.QUOTE_TAG.toString())) {
                            sink.text("\"", null);
                        } else if (parser.getName().equals(SimplifiedDocbookMarkup.TRADEMARK_TAG.toString())) {
                            this.trademark = (char)8482;
                            Object trade = attribs.getAttribute("class");
                            if (trade != null) {
                                this.trademark = DocbookUtils.trademarkFromClass(trade.toString());
                            }
                        } else if (!this.ignorable(parser.getName())) {
                            if (this.simpleTag) {
                                this.handleUnknown(parser, sink, 1);
                            } else {
                                this.handleUnknown(parser, sink, 2);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(SimplifiedDocbookMarkup.ARTICLE_TAG.toString())) {
            sink.body_();
        } else if (parser.getName().equals(SimplifiedDocbookMarkup.ARTICLEINFO_TAG.toString())) {
            this.parent.pop();
        } else if (this.isParent(SimplifiedDocbookMarkup.ARTICLEINFO_TAG.toString())) {
            this.handleArticleInfoEndTags(parser.getName(), sink);
        } else if (HIER_ELEMENTS.contains(parser.getName())) {
            sink.section_(this.level);
            --this.level;
            this.parent.pop();
        } else if (parser.getName().equals(SimplifiedDocbookMarkup.FOOTNOTE_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.AUDIOOBJECT_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.VIDEOOBJECT_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.SECTIONINFO_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.ENTRYTBL_TAG.toString())) {
            this.parent.pop();
            this.ignore = false;
        } else {
            if (this.isParent(SimplifiedDocbookMarkup.FOOTNOTE_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.AUDIOOBJECT_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.VIDEOOBJECT_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.SECTIONINFO_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.ENTRYTBL_TAG.toString())) {
                return;
            }
            if (parser.getName().equals(SimplifiedDocbookMarkup.ITEMIZEDLIST_TAG.toString())) {
                sink.list_();
                this.parent.pop();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.ORDEREDLIST_TAG.toString())) {
                sink.numberedList_();
                this.parent.pop();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.LISTITEM_TAG.toString())) {
                this.parent.pop();
                if (this.isParent(SimplifiedDocbookMarkup.VARIABLELIST_TAG.toString())) {
                    sink.definition_();
                } else if (this.isParent(SimplifiedDocbookMarkup.ORDEREDLIST_TAG.toString())) {
                    sink.numberedListItem_();
                } else {
                    sink.listItem_();
                }
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.VARIABLELIST_TAG.toString())) {
                sink.definitionList_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.VARLISTENTRY_TAG.toString())) {
                sink.definitionListItem_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.TERM_TAG.toString())) {
                sink.definedTerm_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG.toString())) {
                sink.figure_();
                this.parent.pop();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.FIGURE_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.THEAD_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.TFOOT_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.TBODY_TAG.toString())) {
                this.parent.pop();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.CAPTION_TAG.toString())) {
                this.handleCaptionEnd(sink);
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.TABLE_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.INFORMALTABLE_TAG.toString())) {
                sink.table_();
                this.parent.pop();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.TR_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.ROW_TAG.toString())) {
                sink.tableRow_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.TGROUP_TAG.toString())) {
                sink.tableRows_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.ENTRY_TAG.toString()) && this.isParent(SimplifiedDocbookMarkup.THEAD_TAG.toString()) || parser.getName().equals(TH_TAG.toString())) {
                sink.tableHeaderCell_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.ENTRY_TAG.toString())) {
                sink.tableCell_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.PARA_TAG.toString())) {
                this.handleParaEnd(sink);
            } else if (VERBATIM_ELEMENTS.contains(parser.getName())) {
                sink.verbatim_();
            } else if (BOLD_ELEMENTS.contains(parser.getName()) && MONOSPACE_ELEMENTS.contains(parser.getName())) {
                sink.monospaced_();
                sink.bold_();
            } else if (ITALIC_ELEMENTS.contains(parser.getName()) && MONOSPACE_ELEMENTS.contains(parser.getName())) {
                sink.monospaced_();
                sink.italic_();
            } else if (BOLD_ELEMENTS.contains(parser.getName())) {
                sink.bold_();
            } else if (ITALIC_ELEMENTS.contains(parser.getName())) {
                if (this.isBold) {
                    sink.bold_();
                    this.isBold = false;
                } else {
                    sink.italic_();
                }
            } else if (MONOSPACE_ELEMENTS.contains(parser.getName())) {
                sink.monospaced_();
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.TITLE_TAG.toString())) {
                this.handleTitleEnd(sink);
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.ULINK_TAG.toString()) || parser.getName().equals(SimplifiedDocbookMarkup.LINK_TAG.toString())) {
                if (this.isParent(parser.getName())) {
                    this.parent.pop();
                    sink.link_();
                }
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.QUOTE_TAG.toString())) {
                sink.text("\"", null);
            } else if (parser.getName().equals(SimplifiedDocbookMarkup.TRADEMARK_TAG.toString())) {
                sink.text(Character.toString(this.trademark), null);
            } else if (!this.simpleTag && !this.ignorable(parser.getName())) {
                this.handleUnknown(parser, sink, 3);
            }
        }
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = parser.getText();
        if ("PB".equals(text.trim())) {
            sink.pageBreak();
        } else if ("HR".equals(text.trim())) {
            sink.horizontalRule();
        } else if ("LB".equals(text.trim())) {
            sink.lineBreak();
        } else if ("anchor_end".equals(text.trim())) {
            sink.anchor_();
        } else {
            sink.comment(text.trim());
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (!this.ignore) {
            super.handleCdsect(parser, sink);
        }
    }

    protected void handleEntity(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (!this.ignore) {
            super.handleEntity(parser, sink);
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (!this.ignore) {
            super.handleText(parser, sink);
        }
    }

    private void handleArticleInfoStartTags(String name, Sink sink, SinkEventAttributeSet attribs) {
        if (!ARTICLEINFO_ELEMENTS.contains(name)) {
            this.ignore = true;
            return;
        }
        if (name.equals(SimplifiedDocbookMarkup.TITLE_TAG.toString())) {
            sink.title(attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.CORPAUTHOR_TAG.toString())) {
            sink.author(attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.DATE_TAG.toString())) {
            sink.date(attribs);
        }
    }

    private void handleArticleInfoEndTags(String name, Sink sink) {
        if (!ARTICLEINFO_ELEMENTS.contains(name)) {
            this.ignore = false;
            return;
        }
        if (name.equals(SimplifiedDocbookMarkup.TITLE_TAG.toString())) {
            sink.title_();
        } else if (name.equals(SimplifiedDocbookMarkup.CORPAUTHOR_TAG.toString())) {
            sink.author_();
        } else if (name.equals(SimplifiedDocbookMarkup.DATE_TAG.toString())) {
            sink.date_();
        }
    }

    private void handleCaptionStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.isParent(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG.toString())) {
            sink.figureCaption(attribs);
        } else if (this.isParent(SimplifiedDocbookMarkup.INFORMALTABLE_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.TABLE_TAG.toString())) {
            sink.tableCaption(attribs);
        }
        this.parent.push(SimplifiedDocbookMarkup.CAPTION_TAG.toString());
    }

    private void handleCaptionEnd(Sink sink) {
        this.parent.pop();
        if (this.isParent(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG.toString())) {
            sink.figureCaption_();
        } else if (this.isParent(SimplifiedDocbookMarkup.INFORMALTABLE_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.TABLE_TAG.toString())) {
            sink.tableCaption_();
        }
    }

    private void handleEmailStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        try {
            String mailto = parser.nextText();
            sink.link("mailto:" + mailto, attribs);
            sink.monospaced();
            sink.text(mailto, null);
            sink.monospaced_();
            sink.link_();
        }
        catch (IOException e) {
            throw new XmlPullParserException("IOException: " + e.getMessage(), parser, e);
        }
    }

    private void handleFigureStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.figure(attribs);
        this.parent.push(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG.toString());
    }

    private void handleArticleStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.head(attribs);
        this.inHead = true;
        this.parent.push(SimplifiedDocbookMarkup.ARTICLE_TAG.toString());
    }

    private void handleSectionElements(Sink sink, String name, SinkEventAttributeSet attribs) {
        ++this.level;
        sink.section(this.level, attribs);
        this.parent.push(name);
    }

    private void handleAnchorStart(Sink sink, SinkEventAttributeSet attribs) {
        Object id = attribs.getAttribute("id");
        if (id != null) {
            sink.anchor(id.toString(), attribs);
        }
    }

    private void handleImageDataStart(Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        Object fileref = attribs.getAttribute("fileref");
        if (fileref == null) {
            throw new XmlPullParserException("Missing fileref attribute in imagedata!");
        }
        sink.figureGraphics(fileref.toString(), attribs);
    }

    private void handleItemizedListStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.list(attribs);
        this.parent.push(SimplifiedDocbookMarkup.ITEMIZEDLIST_TAG.toString());
    }

    private void handleLinkStart(Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        Object linkend = attribs.getAttribute("linkend");
        if (linkend == null) {
            throw new XmlPullParserException("Missing linkend attribute in link!");
        }
        this.parent.push(SimplifiedDocbookMarkup.LINK_TAG.toString());
        sink.link("#" + linkend.toString(), attribs);
    }

    private void handleListItemStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.isParent(SimplifiedDocbookMarkup.VARIABLELIST_TAG.toString())) {
            sink.definition(attribs);
        } else if (this.isParent(SimplifiedDocbookMarkup.ORDEREDLIST_TAG.toString())) {
            sink.numberedListItem(attribs);
        } else {
            sink.listItem(attribs);
        }
        this.parent.push(SimplifiedDocbookMarkup.LISTITEM_TAG.toString());
    }

    private void handleOrderedListStart(Sink sink, SinkEventAttributeSet attribs) {
        int numeration = 0;
        Object num = attribs.getAttribute("numeration");
        if (num != null) {
            numeration = DocbookUtils.doxiaListNumbering(num.toString());
        }
        sink.numberedList(numeration, attribs);
        this.parent.push(SimplifiedDocbookMarkup.ORDEREDLIST_TAG.toString());
    }

    private void handleParaEnd(Sink sink) {
        if (!this.isParent(SimplifiedDocbookMarkup.CAPTION_TAG.toString()) && !this.isParent(SimplifiedDocbookMarkup.LISTITEM_TAG.toString())) {
            sink.paragraph_();
        }
    }

    private void handleParaStart(Sink sink, SinkEventAttributeSet attribs) {
        if (!this.isParent(SimplifiedDocbookMarkup.CAPTION_TAG.toString()) && !this.isParent(SimplifiedDocbookMarkup.LISTITEM_TAG.toString())) {
            sink.paragraph(attribs);
        }
    }

    private void handleTableStart(Sink sink, SinkEventAttributeSet attribs) {
        Object frame = attribs.getAttribute("frame");
        if (frame != null) {
            attribs.addAttribute("frame", DocbookUtils.doxiaTableFrameAttribute(frame.toString()));
        }
        sink.table(attribs);
        this.parent.push(SimplifiedDocbookMarkup.TABLE_TAG.toString());
    }

    private void handleTitleStart(Sink sink, SinkEventAttributeSet attribs) {
        if (this.isParent(SimplifiedDocbookMarkup.TABLE_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.INFORMALTABLE_TAG.toString())) {
            sink.tableCaption(attribs);
        } else if (this.isParent(SimplifiedDocbookMarkup.ARTICLE_TAG.toString())) {
            sink.title(attribs);
        } else if (this.isParent(SimplifiedDocbookMarkup.SECTION_TAG.toString())) {
            sink.sectionTitle(this.level, attribs);
        } else {
            sink.bold();
        }
    }

    private void handleTitleEnd(Sink sink) {
        if (this.isParent(SimplifiedDocbookMarkup.TABLE_TAG.toString()) || this.isParent(SimplifiedDocbookMarkup.INFORMALTABLE_TAG.toString())) {
            sink.tableCaption_();
        } else if (this.isParent(SimplifiedDocbookMarkup.SECTION_TAG.toString())) {
            sink.sectionTitle_(this.level);
        } else if (this.isParent(SimplifiedDocbookMarkup.ARTICLE_TAG.toString())) {
            sink.title_();
        } else {
            sink.bold_();
        }
    }

    private void handleUlinkStart(Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        Object url = attribs.getAttribute("url");
        if (url == null) {
            throw new XmlPullParserException("Missing url attribute in ulink!");
        }
        this.parent.push(SimplifiedDocbookMarkup.ULINK_TAG.toString());
        sink.link(url.toString(), attribs);
    }

    private void handleVariableListStart(Sink sink, SinkEventAttributeSet attribs) {
        sink.definitionList(attribs);
        this.parent.push(SimplifiedDocbookMarkup.VARIABLELIST_TAG.toString());
    }

    private void handleXrefStart(Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        Object linkend = attribs.getAttribute("linkend");
        if (linkend == null) {
            throw new XmlPullParserException("Missing linkend attribute in xref!");
        }
        sink.link("#" + linkend.toString(), attribs);
        sink.text("Link");
        sink.link_();
    }

    private boolean ignorable(String name) {
        return IGNORABLE_ELEMENTS.contains(name);
    }

    private boolean isParent(String element) {
        if (this.parent.size() > 0) {
            return this.parent.peek().equals(element);
        }
        return false;
    }

    private boolean linkStartTag(String name, Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        if (name.equals(SimplifiedDocbookMarkup.ULINK_TAG.toString())) {
            this.handleUlinkStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.LINK_TAG.toString())) {
            this.handleLinkStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.XREF_TAG.toString())) {
            this.handleXrefStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.ANCHOR_TAG.toString())) {
            this.handleAnchorStart(sink, attribs);
        } else {
            return false;
        }
        return true;
    }

    private boolean listStartTags(String name, Sink sink, SinkEventAttributeSet attribs) {
        if (name.equals(SimplifiedDocbookMarkup.ITEMIZEDLIST_TAG.toString())) {
            this.handleItemizedListStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.ORDEREDLIST_TAG.toString())) {
            this.handleOrderedListStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.LISTITEM_TAG.toString())) {
            this.handleListItemStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.VARIABLELIST_TAG.toString())) {
            this.handleVariableListStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.VARLISTENTRY_TAG.toString())) {
            sink.definitionListItem(attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.TERM_TAG.toString())) {
            sink.definedTerm(attribs);
        } else {
            return false;
        }
        return true;
    }

    private boolean mediaStartTag(String name, Sink sink, SinkEventAttributeSet attribs) throws XmlPullParserException {
        if (name.equals(SimplifiedDocbookMarkup.MEDIAOBJECT_TAG.toString())) {
            this.handleFigureStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG.toString()) || name.equals(SimplifiedDocbookMarkup.FIGURE_TAG.toString())) {
            this.parent.push(name);
        } else if (name.equals(SimplifiedDocbookMarkup.IMAGEDATA_TAG.toString())) {
            this.handleImageDataStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.CAPTION_TAG.toString())) {
            this.handleCaptionStart(sink, attribs);
        } else {
            return false;
        }
        return true;
    }

    private boolean styleStartTags(String name, Sink sink, SinkEventAttributeSet attribs) {
        if (VERBATIM_ELEMENTS.contains(name)) {
            sink.verbatim(SinkEventAttributeSet.BOXED);
        } else if (BOLD_ELEMENTS.contains(name) && MONOSPACE_ELEMENTS.contains(name)) {
            sink.bold();
            sink.monospaced();
        } else if (ITALIC_ELEMENTS.contains(name) && MONOSPACE_ELEMENTS.contains(name)) {
            sink.italic();
            sink.monospaced();
        } else if (BOLD_ELEMENTS.contains(name)) {
            sink.bold();
        } else if (ITALIC_ELEMENTS.contains(name) && "bold".equals(attribs.getAttribute("role"))) {
            sink.bold();
            this.isBold = true;
        } else if (ITALIC_ELEMENTS.contains(name)) {
            sink.italic();
        } else if (MONOSPACE_ELEMENTS.contains(name)) {
            sink.monospaced();
        } else {
            return false;
        }
        return true;
    }

    private boolean tableStartTags(String name, Sink sink, SinkEventAttributeSet attribs) {
        if (name.equals(SimplifiedDocbookMarkup.ENTRYTBL_TAG.toString())) {
            this.parent.push(name);
            this.ignore = true;
            sink.tableCell((SinkEventAttributes)null);
            sink.tableCell_();
        } else if (name.equals(SimplifiedDocbookMarkup.TABLE_TAG.toString()) || name.equals(SimplifiedDocbookMarkup.INFORMALTABLE_TAG.toString())) {
            this.handleTableStart(sink, attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.THEAD_TAG.toString()) || name.equals(SimplifiedDocbookMarkup.TFOOT_TAG.toString()) || name.equals(SimplifiedDocbookMarkup.TBODY_TAG.toString())) {
            this.parent.push(name);
        } else if (name.equals(SimplifiedDocbookMarkup.TGROUP_TAG.toString())) {
            Object colsep;
            int cols = Integer.parseInt((String)attribs.getAttribute("cols"));
            int[] justification = new int[cols];
            int justif = 1;
            Object align = attribs.getAttribute("align");
            if (align != null) {
                String al = align.toString();
                if ("right".equals(al)) {
                    justif = 2;
                } else if ("center".equals(al)) {
                    justif = 0;
                }
            }
            for (int i = 0; i < justification.length; ++i) {
                justification[i] = justif;
            }
            boolean grid = false;
            Object rowsep = attribs.getAttribute("rowsep");
            if (rowsep != null && Integer.parseInt((String)rowsep) == 1) {
                grid = true;
            }
            if ((colsep = attribs.getAttribute("colsep")) != null && Integer.parseInt((String)colsep) == 1) {
                grid = true;
            }
            sink.tableRows(justification, grid);
        } else if (name.equals(SimplifiedDocbookMarkup.TR_TAG.toString()) || name.equals(SimplifiedDocbookMarkup.ROW_TAG.toString())) {
            sink.tableRow(attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.ENTRY_TAG.toString()) && this.isParent(SimplifiedDocbookMarkup.THEAD_TAG.toString()) || name.equals(SimplifiedDocbookMarkup.TH_TAG.toString())) {
            sink.tableHeaderCell(attribs);
        } else if (name.equals(SimplifiedDocbookMarkup.ENTRY_TAG.toString())) {
            sink.tableCell(attribs);
        } else {
            return false;
        }
        return true;
    }

    static {
        META_ELEMENTS.add(SimplifiedDocbookMarkup.ARTICLEINFO_TAG.toString());
        META_ELEMENTS.add(SimplifiedDocbookMarkup.AUTHORBLURB_TAG.toString());
        META_ELEMENTS.add(SimplifiedDocbookMarkup.SUBTITLE_TAG.toString());
        META_ELEMENTS.add(SimplifiedDocbookMarkup.TITLE_TAG.toString());
        META_ELEMENTS.add(SimplifiedDocbookMarkup.TITLEABBREV_TAG.toString());
        ARTICLEINFO_ELEMENTS.add(SimplifiedDocbookMarkup.TITLE_TAG.toString());
        ARTICLEINFO_ELEMENTS.add(SimplifiedDocbookMarkup.CORPAUTHOR_TAG.toString());
        ARTICLEINFO_ELEMENTS.add(SimplifiedDocbookMarkup.DATE_TAG.toString());
        HIER_ELEMENTS.add(SimplifiedDocbookMarkup.SECTION_TAG.toString());
        HIER_ELEMENTS.add(SimplifiedDocbookMarkup.APPENDIX_TAG.toString());
        HIER_ELEMENTS.add(SimplifiedDocbookMarkup.BIBLIOGRAPHY_TAG.toString());
        HIER_ELEMENTS.add(SimplifiedDocbookMarkup.BIBLIODIV_TAG.toString());
        VERBATIM_ELEMENTS.add(SimplifiedDocbookMarkup.PROGRAMLISTING_TAG.toString());
        VERBATIM_ELEMENTS.add(SimplifiedDocbookMarkup.LITERALLAYOUT_TAG.toString());
        BOLD_ELEMENTS.add(SimplifiedDocbookMarkup.COMMAND_TAG.toString());
        BOLD_ELEMENTS.add(SimplifiedDocbookMarkup.USERINPUT_TAG.toString());
        ITALIC_ELEMENTS.add(SimplifiedDocbookMarkup.REPLACEABLE_TAG.toString());
        ITALIC_ELEMENTS.add(SimplifiedDocbookMarkup.SYSTEMITEM_TAG.toString());
        ITALIC_ELEMENTS.add(SimplifiedDocbookMarkup.CITETITLE_TAG.toString());
        ITALIC_ELEMENTS.add(SimplifiedDocbookMarkup.EMPHASIS_TAG.toString());
        ITALIC_ELEMENTS.add(SimplifiedDocbookMarkup.ATTRIBUTION_TAG.toString());
        ITALIC_ELEMENTS.add(SimplifiedDocbookMarkup.LINEANNOTATION_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.COMPUTEROUTPUT_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.REPLACEABLE_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.LITERAL_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.OPTION_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.SYSTEMITEM_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.USERINPUT_TAG.toString());
        MONOSPACE_ELEMENTS.add(SimplifiedDocbookMarkup.FILENAME_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.ABBREV_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.ABSTRACT_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.BIBLIOMIXED_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.BIBLIOMSET_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.COLSPEC_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.EPIGRAPH_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.EXAMPLE_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.FOOTNOTEREF_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.IMAGEOBJECT_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.INLINEMEDIAOBJECT_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.ISSUENUM_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.PHRASE_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.PUBDATE_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.PUBLISHERNAME_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.SPANSPEC_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.TEXTOBJECT_TAG.toString());
        IGNORABLE_ELEMENTS.add(SimplifiedDocbookMarkup.VOLUMENUM_TAG.toString());
    }
}

